      COMPLEX FUNCTION BPBWTH(W,W1,W2)
C
C $$$$$ CALLS ONLY LIBRARY ROUTINES $$$$$
C
C   BPBWTH RETURNS THE COMPLEX FORWARD TRANSFER FUNCTION OF A SIX POLE
C   BUTTERWORTH FILTER AS A FUNCTION OF ANGULAR FREQUENCY W.  THIS
C   FILTER IS A BAND PASS WITH CORNERS AT W1 AND W2 AND A ROLLOFF OF
C   36 DB/OCTAVE.  A FOURIER TRANSFORM CONVENTION OF
C   F(W) = INT F(T)*EXP(-IWT)*DT IS ASSUMED.
C
C                                                     -ALL
      COMPLEX S
      DATA A1,A2,A3/3.863703305,7.464101615,9.141620173/
      W=AMAX1(1.E-2,W)
      W0=(W*W-W1*W2)/(W*(W2-W1))
      S=CMPLX(0.,W0)
      S=S*(A1+S*(A2+S*(A3+S*(A2+S*(A1+S)))))+1
      BPBWTH=1./S
      RETURN
      END
