      subroutine fetch_coord(io_res,filen,stat,slat,slon,sele,iere)
c
c     subroutine will find coordinates for station stat
c
c     input:
c     	io_res- io unit to open
c     	filen - coordinate file to be read
c     	stat  - 4 character station name
c     output:
c     	slat  - station latitude
c     	slon  - station longitude
c     	sele  - station elevation
c     	iere  - integer error flag
c           	= 0 for recovered coordinates
c           	= 999 for no coordinates found
c
      character*(*) stat
      character*4 cstat
      character*(*) filen
	real*4 slat, slon, sele
	real*4 clat, clon, cele
      integer*4 io_res, iere
c
c     Initialize
c
      iere = 0
c
      open(io_res,file=filen)
c
c     Loop over file until the correct one is found
c
100   continue
      read(io_res,101,end=105) cstat, clat, clon, cele
c
      if (cstat(4:4) .eq. '_') then
        cstat(4:4) =  ' '
      endif
c
c     compare station name, channel and date 
c
      if (cstat .eq. stat) then
c
c       match!
c
        slat = clat
        slon = clon
        sele = cele
        go to 110
      else
        go to 100
      end if
c
c     error exit
c
105   continue
      iere = 999
      close(io_res)
      return
c
c     sucessful completion exit
c
110   continue
      iere = 0
      close(io_res)
      return
c
c     format statements
c
101   format(a4,1x,f8.4,1x,f9.4,1x,f6.1)
c
      end
