	subroutine calc_azm(npts,data,az,aaoi)
c
c ...... calculate az .and. aoi of phase onset
c ...... based on a Bob program
c
c
      parameter (maxp  = 65536)

	real*4 data(maxp,*)
	real*4 az(*),aaoi(*)
c
	do i = 1, npts
  	  xx = data(i,1)
	  yy = data(i,2)
	  zz = data(i,3)
c
	  if ((xx .eq. 0.0).and.(yy .eq. 0.0)) then
	    azx = 0 
	  else
	    azx = atan2d(xx,yy)
	    if (azx .lt. 0.0) then
            azx = 360.0 + azx
          end if
        end if
        az(i) = azx
c
	  fmag = sqrt(xx*xx+yy*yy)
	  if ((fmag .eq. 0.0).and.(zz .eq. 0.0)) then
	    aaoi(i)=0.
	  else
	    aaoi(i)=atan2d(fmag,zz)
	  endif
c
      end do
c
	return
	end
