      subroutine save_to_ascii(head,d1,io_save,file_save,iere)
c
c     include files for header and time
c
      include '/usr/local/include/qlib2.inc'
      record /EXT_TIME/ t2_time
      include 'station_hdr.inc'
c
      real*4 d1(*), dt
      integer*4 io_save, iere
      character*(*) file_save
c
      iere = 0
c
c     open output file
c
      open(io_save,file=file_save,access='append')
      call f_int_to_ext(head.begtime,t2_time)
      a0 = 0.0
      do ii = 1, head.num_pts
        if (abs(d1(ii)) .gt. a0) then
          a0 = d1(ii)
        end if
      end do
c
c     write header
c
      dt  = 1.0/head.sample_rate
      write(io_save,100) head.station_id, head.channel_id, 
     .  head.network_id,
     .  dt, head.num_pts, head.azi, head.dip, a0,
     .  t2_time.year, t2_time.doy, t2_time.hour,
     .  t2_time.minute, t2_time.second, 
     .  int(t2_time.usec/usecs_per_tick),
     .  head.desc
c
c     write data
c
      do ii = 1, head.num_pts
        write(io_save,200) ii, d1(ii)/a0
      end do
c
c     close the file
c
      close(io_save)
c
c     format statements
c
100   format(a4,1x,a3,1x,a2,1x,
     .  f5.3,1x,i6,1x,f4.0,1x,f4.0,1x,e12.5,1x,
     .  i4,1x,i3,1x,i2,1x,i2,1x,i2,1x,i5,
     .  1x, a32)
200   format(i6,1x,f12.5)
c
c     all done
c
      return
      end
