C
      SUBROUTINE FFTL(X,N,NDIR,DT,IERR)
C   SINGLE PRECISION DRIVER FOR AN FFT. ALL INTEGERS ARE
C   32 BITS AND ALL FLOATING POINT VARIABLES ARE 32 BITS. FFTL IS
C   INTENDED FOR USE ON THE apollo AT SIO.
C
C $$$$$ CALLS FFT AND REALTR $$$$$
C
C   IF IABS(NDIR).EQ.1 FFTL FOURIER TRANSFORMS THE N POINT REAL TIME
C   SERIES IN ARRAY X.  THE RESULT OVERWRITES X STORED AS
C   (N+2)/2 COMPLEX NUMBERS (NON-NEGATIVE FREQUENCIES ONLY).  IF
C   IABS(NDIR).EQ.2 FFTL FOURIER TRANSFORMS THE (N+2)/2 COMPLEX FOURIER
C   COEFFICIENTS (NON-NEGATIVE FREQUENCIES ONLY) IN ARRAY X
C   (ASSUMING THE SERIES IS HERMITIAN).  THE RESULTING N POINT REAL
C   TIME SERIES OVERWRITES X.  IF NDIR.GT.0 THE FORWARD TRANSFORM USES
C   THE SIGN CONVENTION EXP(I*W*T).  IF NDIR.LT.0 THE FORWARD TRANSFORM
C   USES THE SIGN CONVENTION EXP(-I*W*T).  THE FORWARD TRANSFORM IS
C   NORMALIZED SUCH THAT A SINE WAVE OF UNIT AMPLITUDE IS TRANSFORMED
C   INTO DELTA FUNCTIONS OF UNIT AMPLITUDE.  THE BACKWARDS TRANSFORM IS
C   NORMALIZED SUCH THAT TRANSFORMING FORWARD AND THEN BACK RECOVERS
C   THE ORIGINAL SERIES.  IERR IS NORMALLY ZERO.  IF IERR.EQ.1 THEN FFT
C   HAS NOT BEEN ABLE TO FACTOR THE SERIES.  HOWEVER, X HAS BEEN
C   SCRAMBLED BY REALTR.  NOTE THAT IF N IS ODD THE LAST POINT WILL NOT
C   BE USED IN THE TRANSFORM.
C
C                                                     -RPB
C
C  THE SCALING IN FFTL DIFFERS FROM THAT IN THE USUAL FFTL ON THE PRIME.
C  THE FORWARD TRANSFORM IS SPECTRUM(W)=DT*SUM(0,N-1)X(J)*EXP(-I*W*J*DT)
C  THE SPACING IN W IS 2*PI/(N*DT)
C                                                     -ALL
C
      IMPLICIT INTEGER*4(I-N)
c     DIMENSION X(1)
      DIMENSION X(*)
      N2=N/2
      IDIR=NDIR
      IF(IDIR.LT.0) IDIR=-IDIR
      GO TO (1,2),IDIR
C   DO FORWARD TRANSFORM (IE. TIME TO FREQUENCY).
 1    CALL FFT(X,X(2),N2,N2,N2,2,IERR)
      CALL RLTR(X,X(2),N2,2)
      N1=2*N2+2
C     SCALE=1./N
      SCALE=0.5*DT
      IF(NDIR.GT.0) GO TO 3
      DO 5 I=4,N,2
 5    X(I)=-X(I)
      GO TO 3
C   DO BACKWARD TRANSFORM (IE. FREQUENCY TO TIME).
 2    IF(NDIR.GT.0) GO TO 6
      DO 7 I=4,N,2
 7    X(I)=-X(I)
 6    X(2)=0.
      N1=2*N2
      X(N1+2)=0.
      CALL RLTR(X,X(2),N2,-2)
      CALL FFT(X,X(2),N2,N2,N2,-2,IERR)
C     SCALE=.5
      SCALE=1./(N*DT)
C   NORMALIZE THE TRANSFORM.
 3    DO 4 I=1,N1
 4    X(I)=SCALE*X(I)
      RETURN
      END
