
      subroutine amaxper(npts,dt,fc,amaxmm,pmax,imax)
c 
c     compute maximum amplitude and its associated period
c
c     input:
c             npts   - number of points in timeseries
c             dt     - sample spacing in sec
c             fc     - input timeseries
c     output:
c             amaxmm - raw maximum
c             pmax   - period of maximum
c             imax   - index of maxmimum point
c
      real*4 fc(*)
c
      include 'numerical.h'
c
      imax = 1
      amax = 0.
      amaxmm = 0.0
      pmax = 0.0
      do i = 1,npts
        x = abs(fc(i))
        if (x .gt. amax) then
          imax = i
          amax = x
        endif
      end do
c
c     compute period of maximum
c
      if (fc(imax) .gt. 0.) then
        pp = 0.
        j = imax
    2   j = j+1
        if(fc(j) .gt. 0.) then
          pp = pp+dt
          go to 2
        endif
        pp = pp+dt*(0.-fc(j-1))/(fc(j)-fc(j-1))
        pm = 0.
        j = imax
    3   j = j-1
        if(fc(j) .gt. 0.) then
          pm = pm+dt
          go to 3
        endif
        pm = pm+dt*(0.-fc(j+1))/(fc(j)-fc(j+1))
      else
        pp = 0.
        j = imax
    4   j = j+1
        if(fc(j) .lt. 0.) then
          pp = pp+dt
          go to 4
        endif
        pp = pp+dt*(0.-fc(j-1))/(fc(j)-fc(j-1))
        pm = 0.
        j = imax
    5   j = j-1
        if(fc(j) .lt. 0.) then
          pm = pm+dt
          go to 5
        endif
        pm = pm+dt*(0.-fc(j+1))/(fc(j)-fc(j+1))
      endif
c
      pmax = 2.*(pm+pp)
      amaxmm = amax
c
      return
      end
