	subroutine check_window(beg_time,end_time,org_time,dist,iere)
c
c     subroutine to check window length
c
c     input:  
c             beg_time - data begin time
c             end_time - data end time
c             org_time - orgin time
c             dist - distance from this data to event in km
c     output:  
c             iere   - error return code
c                      998 if window begins too late
c                      999 if window ends too early
c                      0 otherwise
c
      include '/usr/local/include/qlib2.inc'
      record /INT_TIME/ beg_time, end_time, org_time, t1_time, t2_time
      record /EXT_TIME/ ext_time
c
      character*256 cval
      integer*4 iere, it1s, it2s, it1t, it2t
      real*4 dist, t1, t2
      real*8 td1, td2
ccccc
c
       data xmax_speed /4.5/
       data xmin_speed_0 /2.5/
       data xmin_speed_1 /2.0/
c
c     initialize error return
c
      iere = 0
c
c     check distance for necessary windows - these numbers from redi.config
c     and extract_seis.c
c
c      /* Compute end time. */
c     if (dist_km <= 100) tdif = dist_km / Min_Speed_0;
c     else tdif = dist_km / Min_Speed_1;
c
c	setenv  REDI_EVENT_MIN_SPEED_0          2.0
c 	setenv  REDI_EVENT_MIN_SPEED_1          1.8
c	setenv  REDI_EVENT_MAX_SPEED            8.5
c
cccccc
c     96/05/28 - new cda software means less slop in requests
c
c      t1 = dist/xmax_speed - 5.0
c      if (dist .le. 100.) then
c        t2 = dist/xmin_speed_0 + 5.0
c      else
c        t2 = dist/xmin_speed_1 + 5.0
c      end if
cccccc
c    96/09/22 - pick up the enviroment variables directly
c
c      call getenv('REDI_EVENT_MAX_SPEED',cval)
c      call cipnum(cval, xmax_speed, iflag)
c      if (iflag .ne. 0) then
c        iere = 998
c        return
c      end if
c      call getenv('REDI_EVENT_MIN_SPEED_0',cval)
c      call cipnum(cval, xmin_speed_0, iflag)
c      if (iflag .ne. 0) then
c        iere = 998
c        return
c      end if
c      call getenv('REDI_EVENT_MIN_SPEED_1',cval)
c      call cipnum(cval, xmin_speed_1, iflag)
c      if (iflag .ne. 0) then
c        iere = 998
c        return
c      end if
c
      t1 = dist/xmax_speed
      if (dist .le. 100.) then
        t2 = dist/xmin_speed_0
      else
        t2 = dist/xmin_speed_1
      end if
cccccc
      it1s = int(t1)
      it1t = (t1 - it1s)*ticks_per_sec
      it2s = int(t2)
      it2t = (t2 - it2s)*ticks_per_sec
c
c     compute the bounding times by adding t1 and t2 to org_time
c                                    
      call f_add_time(org_time, it1s, it1t, t1_time)
      call f_add_time(org_time, it2s, it2t, t2_time)
c
c     compare time series begin and end times with this window
c
      td1 = f_tdiff(beg_time, t1_time)
      td2 = f_tdiff(end_time, t2_time)
c
c     call f_int_to_ext(org_time,ext_time)
c     print*, 'Org time: ',ext_time.year, ext_time.doy, ext_time.hour,
c    .         ext_time.minute, ext_time.second, ext_time.ticks
c     call f_int_to_ext(beg_time,ext_time)
c     print*, 'Beg time: ',ext_time.year, ext_time.doy, ext_time.hour,
c    .         ext_time.minute, ext_time.second, ext_time.ticks
c     call f_int_to_ext(t1_time,ext_time)
c     print*, 'T1  time: ',ext_time.year, ext_time.doy, ext_time.hour,
c    .         ext_time.minute, ext_time.second, ext_time.ticks
c     call f_int_to_ext(end_time,ext_time)
c     print*, 'End time: ',ext_time.year, ext_time.doy, ext_time.hour,
c    .         ext_time.minute, ext_time.second, ext_time.ticks
c     call f_int_to_ext(t2_time,ext_time)
c     print*, 'T2  time: ',ext_time.year, ext_time.doy, ext_time.hour,
c    .         ext_time.minute, ext_time.second, ext_time.ticks
c
      if (td1 .gt. 0.d0) then
        iere = 998
        return
      end if
      if (td2 .lt. 0.d0) then
        iere = 999
        return
      end if
c
      return
      end
