/* generates a grid value for spline parametrized
model files  */

#include <stdio.h>
#include <math.h>
#include <stdlib.h>

#define PI   3.14159265358979312
#define CONV 0.01745329
#define D    double
#define F    float
#define TOL 1.5
#define BIG 1.0e34
#define LOGBIG 34.0
#define SMALL 1.0e-34

#define U (unsigned)
#define STOP(x) {printf("\n x \n"); exit();}
#define stop(x) {printf("\n" x "\n"); exit(99);}

float *farray1();
float **farray2();
void free_farray2();
void free_farray1();
void fill_hh();
void rotmatrix();
float *assolegendre();

void harmogrid1(maxs,coef,conven)
int maxs;
float *coef;   
char *conven; 
{
float grid,*cossintphi,*p,*y,fac;
static int smin,smax;
static char aeo;
float theta,phi,lat,lon;
int s,t,index,i,j,k,imax;
float cosphi,sinphi,costph,sintph,temp;
char string[20],string2[20];

 smin=0;
 smax=maxs;
 imax=(maxs+1)*(maxs+1);
 
 for(index=0,s=0;s<smin;s++)
   for(t=0;t<2*s+1;t++)
     coef[index++]=0.0;

 printf("longitude (0,+360)   latitude (-90,+90)\n");
 do{
   printf("\nlon & lat of grid or 'q' to quit: ");
   scanf("%s",string);
   if(string[0]=='q')break;
   scanf("%s",string2);

   sscanf(string,"%f",&lon);
   sscanf(string2,"%f",&lat);  

   p=farray1(0,imax-1);
   theta=CONV*(90.-lat);
   if(theta<0.0) theta=0.0;
   if(theta>PI) theta=PI;
   for(index=-1,s=0;s<=maxs;s++)
     { y=assolegendre(theta,s,conven);
     for(t=0;t<=s;t++)
       { p[++index]=y[t];
       if(t) p[++index]=y[t];
       }
     }
   
   cossintphi=farray1(0,imax-1);
   
   if(lon<0)lon=lon+360;
   phi=CONV*lon;
   cosphi=(float)cos((double)phi);
   sinphi=(float)sin((double)phi);
   
   for(index=-1,s=0;s<=maxs;s++)
     for(costph=1.0,sintph=0.0,t=0;t<=s;t++)
       { cossintphi[++index]=costph;
       if(t) cossintphi[++index]=sintph;
       temp=costph*cosphi-sintph*sinphi;
       sintph=sintph*cosphi+costph*sinphi;
       costph=temp;
       }
   
   for(grid=0.0,k=0;k<imax;k++)
     grid+=coef[k]*cossintphi[k]*p[k];       
   printf("%g\t%g\t%g\n",lon,lat,grid);
   free_farray1(cossintphi,0);
   free_farray1(p,0); 
 } while(string[0]!='q');
     
}

/* calculate associated Legendre functions*/

float *assolegendre(theta,l,conventn)
float theta;
int l;
char *conventn;
{
static int current_dim=0;
static float *x,**d;
static int mem;
int dim,m;
void *test;
float fac,sign;

 dim=2*l+1;
 if(dim>current_dim)
   { if(current_dim)
     { free(x);
     free_farray2(d,0,0,mem);
     }
   if( (x=(float *)malloc(sizeof(float)*dim)) ==NULL)
     STOP(assolegendre: malloc failed 1);
   d=farray2(0,0,-l,l);
   current_dim=dim;
   mem=-l;
   }
	
 rotmatrix(0,l,theta,d);
 
 if(!strcmp(conventn,"X^"))
   { for(m=0;m<=l;m++)
     { fac=((float)(2*l+1))/(8.*PI);
     if(m) fac*=2.0;
     fac=(float)sqrt((double)fac);
     x[m]=fac*d[0][m];
     }
   }
 else STOP(assolegendre: illegal convention);	
 return(x);
}



/********************************************/
/* b-splines on arbitrary spacing 
   CHM 12/97 */
float spl(ord,nknots,knot,xi)
int ord,nknots;
float *knot,xi;

{
int ii,Nx;
float *hh,rho_x;
float coefa,coefb,coefc,coefd;
  
 Nx=nknots-1;
  /* Compute vector hh of spacings */
 hh=farray1(0,Nx-1);
 fill_hh(hh,knot,Nx);
  
  /* Consistency checks */
 if((xi-(float)TOL)>knot[Nx]){
   printf("xi=%g / knot[%d]=%g",xi,Nx,knot[Nx]);
   stop("spl: xi>knot[Nx]");
  }
  else if((xi+(float)TOL)<knot[0]){
    printf("xi=%g / knot[0]=%g",xi,knot[0]);
    stop("spl: xi<knot[0]");
  }
  else if(ord>Nx)
    stop("spl: order > Nx");
  
  if(ord==0){	/* LHS */
  float denom;
  denom=3.*hh[ord]*hh[ord]+3.*hh[ord]*hh[ord+1]+hh[ord+1]*hh[ord+1];
  if(xi>=knot[ord]&&xi<=knot[ord+1]){			/* x0<=x<=x1 */
    coefa=4./(hh[ord]*(hh[ord]+hh[ord+1])*denom);
    coefb=0.0;
    coefc=-12/denom;
    coefd=4*(2*hh[ord]+hh[ord+1])/denom;
    
    rho_x=coefa*(xi-knot[ord])*(xi-knot[ord])*(xi-knot[ord]);
    rho_x+=coefb*(xi-knot[ord])*(xi-knot[ord]);
    rho_x+=coefc*(xi-knot[ord]);
    rho_x+=coefd;
    }
  else if(xi>knot[ord+1]&xi<=knot[ord+2]){		/* x1<=x<=x2 */
    coefa=-4./(hh[ord+1]*(hh[ord]+hh[ord+1])*denom);
    coefb=12/((hh[ord]+hh[ord+1])*denom);
    coefc=-12.*hh[ord+1]/((hh[ord]+hh[ord+1])*denom);
    coefd=4.*hh[ord+1]*hh[ord+1]/((hh[ord]+hh[ord+1])*denom);
      
    rho_x=coefa*(xi-knot[ord+1])*(xi-knot[ord+1])*(xi-knot[ord+1]);
    rho_x+=coefb*(xi-knot[ord+1])*(xi-knot[ord+1]);
    rho_x+=coefc*(xi-knot[ord+1]);
    rho_x+=coefd;
    }
    else						/* x>x2 */
      rho_x=0.0; 
  }
  
  else if(ord==1){	/* LHS+1 */
  float denom,denomsum,dd;
    denom=(3.*hh[ord-1]*hh[ord-1]+4.*hh[ord-1]*hh[ord]+hh[ord]*hh[ord]+
           2.*hh[ord-1]*hh[ord+1]+hh[ord]*hh[ord+1]);
    denomsum=hh[ord-1]+hh[ord]+hh[ord+1];
    dd=denomsum*denom;
    if(xi>=knot[ord-1]&&xi<=knot[ord]){			/* x0<=x<=x1 */
      coefa=-4.*(3.*hh[ord-1]+2.*hh[ord]+hh[ord+1])/
      	    (hh[ord-1]*(hh[ord-1]+hh[ord])*dd);
      coefb=0.;
      coefc=12./denom;
      coefd=0.;
      
      rho_x =coefa*(xi-knot[ord-1])*(xi-knot[ord-1])*(xi-knot[ord-1]);
      rho_x+=coefb*(xi-knot[ord-1])*(xi-knot[ord-1]);
      rho_x+=coefc*(xi-knot[ord-1]);
      rho_x+=coefd;
    }
    
    else if(xi>=knot[ord]&&xi<=knot[ord+1]){			/* x1<=x<=x2 */
      coefa=4.*(2.*hh[ord-1]*hh[ord-1]+6.*hh[ord-1]*hh[ord]+3.*hh[ord]*hh[ord]+3.*hh[ord-1]*hh[ord+1]+
            3.*hh[ord]*hh[ord+1]+hh[ord+1]*hh[ord+1])/
            (hh[ord]*(hh[ord-1]+hh[ord])*(hh[ord]+hh[ord+1])*dd);
      coefb=-12.*(3.*hh[ord-1]+2.*hh[ord]+hh[ord+1])/
      	    ((hh[ord-1]+hh[ord])*dd);
      coefc=12.*(-2.*hh[ord-1]*hh[ord-1]+hh[ord]*hh[ord]+hh[ord]*hh[ord+1])/
      	    ((hh[ord-1]+hh[ord])*dd);
      coefd=4.*hh[ord-1]*(4.*hh[ord-1]*hh[ord]+3.*hh[ord]*hh[ord]+2.*hh[ord-1]*hh[ord+1]+3.*hh[ord]*hh[ord+1])/
      	    ((hh[ord-1]+hh[ord])*dd);
      	    
      rho_x=coefa*(xi-knot[ord])*(xi-knot[ord])*(xi-knot[ord]);
      rho_x+=coefb*(xi-knot[ord])*(xi-knot[ord]);
      rho_x+=coefc*(xi-knot[ord]);
      rho_x+=coefd;
    }
    
    else if(xi>=knot[ord+1]&&xi<=knot[ord+2]){			/* x2<=x<=x3 */
      dd*=(hh[ord]+hh[ord+1]);
      coefa=-4.*(2.*hh[ord-1]+hh[ord])/(hh[ord+1]*dd);
      coefb=12.*(2.*hh[ord-1]+hh[ord])/dd;
      coefc=-12.*(2.*hh[ord-1]+hh[ord])*hh[ord+1]/dd;
      coefd=4.*(2.*hh[ord-1]+hh[ord])*hh[ord+1]*hh[ord+1]/dd;
      
      rho_x=coefa*(xi-knot[ord+1])*(xi-knot[ord+1])*(xi-knot[ord+1]);
      rho_x+=coefb*(xi-knot[ord+1])*(xi-knot[ord+1]);
      rho_x+=coefc*(xi-knot[ord+1]);
      rho_x+=coefd;
    }
    else						/* x>x3 */
      rho_x=0.0; 
  }
  
  else if(ord==Nx-1){		/* RHS-1 */
  float denom,denomsum,dd;
    denom=hh[ord-2]*hh[ord-1]+hh[ord-1]*hh[ord-1]
      +2.*hh[ord-2]*hh[ord]+4.*hh[ord-1]*hh[ord]+3.*hh[ord]*hh[ord];
    denomsum=hh[ord-2]+hh[ord-1]+hh[ord];
    dd=denomsum*denom;
    if(xi>=knot[ord-2]&&xi<=knot[ord-1]){	/* x0<=x<=x1 */
      coefa=4.*(hh[ord-1]+2.*hh[ord])/(hh[ord-2]*(hh[ord-2]+hh[ord-1])*dd);
      coefb=coefc=coefd=0.0;
      
      rho_x =coefa*(xi-knot[ord-2])*(xi-knot[ord-2])*(xi-knot[ord-2]);
      rho_x+=coefb*(xi-knot[ord-2])*(xi-knot[ord-2]);
      rho_x+=coefc*(xi-knot[ord-2]);
      rho_x+=coefd;
    }
    
    else if(xi>=knot[ord-1]&&xi<=knot[ord]){	/* x1<=x<=x2 */
      coefa=-4.*(hh[ord-2]*hh[ord-2]+3.*hh[ord-2]*hh[ord-1]
		 +3.*hh[ord-1]*hh[ord-1]+3.*hh[ord-2]*hh[ord]+
             6.*hh[ord-1]*hh[ord]+2.*hh[ord]*hh[ord])/
             (hh[ord-1]*(hh[ord-2]+hh[ord-1])*(hh[ord-1]+hh[ord])*dd);
      coefb=12.*(hh[ord-1]+2.*hh[ord])/((hh[ord-2]+hh[ord-1])*dd);
      coefc=12.*hh[ord-2]*(hh[ord-1]+2.*hh[ord])/((hh[ord-2]+hh[ord-1])*dd);
      coefd=4.*hh[ord-2]*hh[ord-2]*(hh[ord-1]+2.*hh[ord])/((hh[ord-2]+hh[ord-1])*dd);
      
      rho_x =coefa*(xi-knot[ord-1])*(xi-knot[ord-1])*(xi-knot[ord-1]);
      rho_x+=coefb*(xi-knot[ord-1])*(xi-knot[ord-1]);
      rho_x+=coefc*(xi-knot[ord-1]);
      rho_x+=coefd;
    }
    
    else if(xi>=knot[ord]&&xi<=knot[ord+1]){	/* x2<=x<=x3 */
      dd*=(hh[ord-1]+hh[ord]);
      coefa=4.*(hh[ord-2]+2.*hh[ord-1]+3.*hh[ord])/(hh[ord]*dd);
      coefb=-12.*(hh[ord-2]+2.*hh[ord-1]+3.*hh[ord])/dd;
      coefc=12.*(-hh[ord-2]*hh[ord-1]-hh[ord-1]*hh[ord-1]+2.*hh[ord]*hh[ord])/dd;
      coefd=4.*hh[ord]*(3.*hh[ord-2]*hh[ord-1]+3.*hh[ord-1]*hh[ord-1]
			+2.*hh[ord-2]*hh[ord]+4.*hh[ord-1]*hh[ord])/dd;
      
      rho_x=coefa*(xi-knot[ord])*(xi-knot[ord])*(xi-knot[ord]);
      rho_x+=coefb*(xi-knot[ord])*(xi-knot[ord]);
      rho_x+=coefc*(xi-knot[ord]);
      rho_x+=coefd;
    }
    else						/* x>x4 */
      rho_x=0.0;
  }
  
  else if(ord==Nx){		/* RHS */
  float denom;
    denom=(hh[ord-2]+hh[ord-1])*(hh[ord-2]*hh[ord-2]+3.*hh[ord-2]*hh[ord-1]+3.*hh[ord-1]*hh[ord-1]);
    if(xi>=knot[ord-2]&&xi<=knot[ord-1]){	/* x0<=x<=x1 */
      coefa=4./(hh[ord-2]*denom);
      coefb=coefc=coefd=0.0;
      
      rho_x =coefa*(xi-knot[ord-2])*(xi-knot[ord-2])*(xi-knot[ord-2]);
      rho_x+=coefb*(xi-knot[ord-2])*(xi-knot[ord-2]);
      rho_x+=coefc*(xi-knot[ord-2]);
      rho_x+=coefd;
    }
    
    else if(xi>=knot[ord-1]&&xi<=knot[ord]){	/* x1<=x<=x2 */
      coefa=-4./(hh[ord-1]*denom);
      coefb=12/denom;
      coefc=12*hh[ord-2]/denom;
      coefd=4.*hh[ord-2]*hh[ord-2]/denom;
      
      rho_x =coefa*(xi-knot[ord-1])*(xi-knot[ord-1])*(xi-knot[ord-1]);
      rho_x+=coefb*(xi-knot[ord-1])*(xi-knot[ord-1]);
      rho_x+=coefc*(xi-knot[ord-1]);
      rho_x+=coefd;
    }
    
    else						/* x>x2 */
      rho_x=0.0;
  }
  
  else{			/* Away from borders */
  float denom1,denom2,denom;
    denom1=hh[ord-2]+hh[ord-1]+hh[ord]+hh[ord+1];
    if(xi>=knot[ord-2]&&xi<=knot[ord-1]){	/* x0<=x<=x1 */
      coefa=4./(hh[ord-2]*(hh[ord-2]+hh[ord-1])*(hh[ord-2]+hh[ord-1]+hh[ord])*denom1);
      coefb=coefc=coefd=0.;
      
      rho_x =coefa*(xi-knot[ord-2])*(xi-knot[ord-2])*(xi-knot[ord-2]);
      rho_x+=coefb*(xi-knot[ord-2])*(xi-knot[ord-2]);
      rho_x+=coefc*(xi-knot[ord-2]);
      rho_x+=coefd;
    }
    else if(xi>=knot[ord-1]&&xi<=knot[ord]){	/* x1<=x<=x2 */
      denom2=(hh[ord-2]+hh[ord-1])*(hh[ord-2]+hh[ord-1]+hh[ord]);
      denom=denom1*denom2;
      
      coefa=-4.*(hh[ord-2]*hh[ord-2]+3.*hh[ord-2]*hh[ord-1]+3.*hh[ord-1]*hh[ord-1]+2.*hh[ord-2]*hh[ord]+
      4.*hh[ord-1]*hh[ord]+hh[ord]*hh[ord]+hh[ord-2]*hh[ord+1]+2.*hh[ord-1]*hh[ord+1]+hh[ord]*hh[ord+1])/
      (hh[ord-1]*(hh[ord-1]+hh[ord])*(hh[ord-1]+hh[ord]+hh[ord+1])*denom);
      coefb=12./denom;
      coefc=12.*hh[ord-2]/denom;
      coefd=4.*hh[ord-2]*hh[ord-2]/denom;
      
      rho_x =coefa*(xi-knot[ord-1])*(xi-knot[ord-1])*(xi-knot[ord-1]);
      rho_x+=coefb*(xi-knot[ord-1])*(xi-knot[ord-1]);
      rho_x+=coefc*(xi-knot[ord-1]);
      rho_x+=coefd;
    }
    
    else if(xi>=knot[ord]&&xi<=knot[ord+1]){	/* x2<=x<=x3 */
      denom2=(hh[ord-1]+hh[ord])*(hh[ord-2]+hh[ord-1]+hh[ord])*(hh[ord-1]+hh[ord]+hh[ord+1]);
      denom=denom1*denom2;
      
      coefa=4.*(hh[ord-2]*hh[ord-1]+hh[ord-1]*hh[ord-1]+2.*hh[ord-2]*hh[ord]+4.*hh[ord-1]*hh[ord]+3.*hh[ord]*hh[ord]+
      	    hh[ord-2]*hh[ord+1]+2.*hh[ord-1]*hh[ord+1]+3.*hh[ord]*hh[ord+1]+hh[ord+1]*hh[ord+1])/
      	    (hh[ord]*(hh[ord]+hh[ord+1])*denom);
      coefb=-12.*(hh[ord-2]+2.*hh[ord-1]+2.*hh[ord]+hh[ord+1])/denom;
      coefc=12.*(-hh[ord-2]*hh[ord-1]-hh[ord-1]*hh[ord-1]+hh[ord]*hh[ord]+hh[ord]*hh[ord+1])/denom;
      coefd=4.*(2.*hh[ord-2]*hh[ord-1]*hh[ord]+2.*hh[ord-1]*hh[ord-1]*hh[ord]+hh[ord-2]*hh[ord]*hh[ord]+
      	    2.*hh[ord-1]*hh[ord]*hh[ord]+hh[ord-2]*hh[ord-1]*hh[ord+1]+hh[ord-1]*hh[ord-1]*hh[ord+1]+
      	    hh[ord-2]*hh[ord]*hh[ord+1]+2.*hh[ord-1]*hh[ord]*hh[ord+1])/denom;
     
      rho_x=coefa*(xi-knot[ord])*(xi-knot[ord])*(xi-knot[ord]);
      rho_x+=coefb*(xi-knot[ord])*(xi-knot[ord]);
      rho_x+=coefc*(xi-knot[ord]);
      rho_x+=coefd;
    }
             
    else if(xi>=knot[ord+1]&&xi<=knot[ord+2]){	/* x3<=x<=x4 */
      denom2=(hh[ord]+hh[ord+1])*(hh[ord-1]+hh[ord]+hh[ord+1]);
      denom=denom1*denom2;
      
      coefa=-4./(hh[ord+1]*denom);
      coefb=12/denom;
      coefc=-12*hh[ord+1]/denom;
      coefd=4.*hh[ord+1]*hh[ord+1]/denom;
      
      rho_x=coefa*(xi-knot[ord+1])*(xi-knot[ord+1])*(xi-knot[ord+1]);
      rho_x+=coefb*(xi-knot[ord+1])*(xi-knot[ord+1]);
      rho_x+=coefc*(xi-knot[ord+1]);
      rho_x+=coefd;
    }
    
    else						/* x>x4 */
      rho_x=0.0;
  }
  free_farray1(hh,0);
  return(rho_x);
}

void fill_hh(hh,knot,Nx)
float *hh,*knot;
int Nx;
{
int ii;

  for(ii=0;ii<Nx;ii++)
    hh[ii]=knot[ii+1]-knot[ii];
}



/*******1-D*******/
float *farray1(n11,n12)
int n11,n12;
{
float *m;
	m=(float *)malloc( U (n12-n11+1)*sizeof(float) );
	if(!m) STOP(allocation error in farray1);
	return(m-n11);
}
void free_farray1(a,n11)
float *a;
int n11;
{
	free(&a[n11]);
}

/*******2-D*******/
float **farray2(n11,n12,n21,n22)
int n11,n12,n21,n22;
{
int i;
float **m;
	m=(float **)malloc( U (n12-n11+1)*sizeof(float*) );
	if(!m) STOP(allocation error 1 in farray2);
	m-=n11;
	
	for(i=n11;i<=n12;i++)
	{ m[i]=(float *)malloc( U (n22-n21+1)*sizeof(float) );
	  if(!m[i]) STOP(allocation error 2 in farray2);
	  m[i]-=n21;
	}
	return(m);
}
void free_farray2(a,n11,n12,n21)
float **a;
int n11,n12,n21;
{
int i;	
    for(i=n11;i<=n12;i++) {
        free(&(a[i][n21]));
    }
    free(&(a[n11]));
}

/*************************************************/ 
void rotmatrix(Nmax,l,beta,d)
int Nmax,l;
float beta;
float **d;   /* 2*Nmax+1 by 2*l+1  matrix */
{
int swtch,change;
int N,m;
float shbt,chbt,sbt,cbt,logf,logs;
float fN,t1,sign,part,fac,temp;
int mult,i;
	
	
	if(Nmax>l) STOP(rotmatrix: N larger than l);
	if(l==0) 
	{ **d=1.0;
	  return;
	}
	
	change=0;
	if(beta<0)
	{ change=1;
	   beta=-beta;
	}
	
	swtch=1;
	if(beta>PI/2.)
	{ beta=PI-beta;
	  swtch=-1;
	}
	
	if(beta<1.e-04 && beta>-1.e-04) beta=0.0;
	if(beta<0.0) STOP(rotmatrix: illegal beta);
/*-------------------------------*/
	
	if(beta==0.0)
	{ for(N=-Nmax;N<=Nmax;N++)
	  { sign=1.0;
	    for(m=-l;m<=l;m++)
	    { d[N][m]=0.0;
	      if((N*swtch)==m) d[N][m]=sign;
	      sign*=swtch;
	    }
	  }
	  return ;
	}
/*-------------------------------*/
        for(N=-Nmax;N<=Nmax;N++)	   /*zero l.h.s. of matrix*/
	for(m=-l;m<=0;m++) d[N][m]=0.0;
	    
 /*set up parameters*/
        shbt=sin( (D)(0.5*beta) );
        chbt=cos( (D)(0.5*beta) );
        sbt=2.0*shbt*chbt;
        cbt=2.0*chbt*chbt-1.0;
        logf= log10( (D)(chbt/shbt) );
        logs= log10( (D)shbt );
        
/*iterate from last column using 1. as starting value*/
        for(N=-Nmax;N<=Nmax;N++)
        { fN=(F) N;
          d[N][l]=1.0;
          for(m=l-1;m>=abs(N);m--)
          { if(m+1==l) t1=0.0;
            else t1=-d[N][m+2]* sqrt( (D)((l+2+m)*(l-1-m)) );
            d[N][m]=t1-(2.0/sbt)*(cbt*(F)(m+1)-fN)*d[N][m+1];
            d[N][m]/= sqrt( (D)((l+m+1)*(l-m)) );
            
            if( fabs((D)d[N][m])>=BIG && m!=abs(N) )
            { d[N][-m]=LOGBIG;
              d[N][m]/=BIG;
              d[N][m+1]/=BIG;
            }
          }
        }
        
/*set up normalization for last column;
 *using the first column as temp working space to store the logrithms.
 */
         t1=logs*(F)(2*l);
         for(N=-l+1;N<=-Nmax;N++)
           t1+=logf+0.5* log10( (D)(l+1-N)/(D)(N+l) );
         d[-Nmax][-l]=t1;
         for(N=-Nmax+1;N<=Nmax;N++)
           d[N][-l]=d[N-1][-l]+logf+0.5* log10( (D)(l-N+1)/(D)(l+N) );                  
/*renormalize rows*/
        sign=1.0;
        if( (l-Nmax)%2 ) sign=-1.0;
        for(N=-Nmax;N<=Nmax;sign=-sign,N++)
        { part=d[N][-l];
          mult=1;
          while(fabs((D) part)>=LOGBIG)
          { mult*=2;
            part*=0.5;
          }
          fac= pow(10.0, (D)part);
          for(m=l;m>=abs(N);m--)
          { if(d[N][-m+1]!=0.0 && -m+1<-abs(N) )
            { part=part*(F)(mult)+d[N][-m+1];
              mult=1;
              while(fabs((D) part)>=LOGBIG)
              { mult*=2;
                part*=0.5;
              }
              fac= pow(10.0, (D) part);
            }
            for(i=0;i<mult;i++)
            { d[N][m]*=fac;
              if( fabs((D)d[N][m])<=SMALL ) break;
            }
            d[N][m]*=sign;
          }
        }
/* correction for beta<0, using d[N][m](-b)=(-1)**(N+m)*d[N][m](b) */

	if(change)
	{ for(N=-Nmax;N<=Nmax;N++)
	  { sign=1.0; if((l+N)%2) sign=-1.0;
	    for(m=l;m>=abs(N);m--,sign=-sign) d[N][m]*=sign;
	  }
	}

/*fill rest of matrix*/
	if(swtch<0)
	{ sign=1.0;
	  if( (l-Nmax)%2 ) sign=-1.0;
	  for(N=-Nmax;N<=Nmax;sign=-sign,N++)
	  for(m=-l;m<=-abs(N);m++)
	    d[N][m]=sign*d[N][-m];
	    
	  for(N=-Nmax;N<=Nmax;N++)
	  for(sign=1.0,m=abs(N);m<=l;sign=-sign,m++)
	  { d[N][m]=sign*d[-N][-m];
	    if(m<=Nmax)
	    { d[-m][-N]=d[N][m];
	      d[m][N]=d[-N][-m];
	    }
	  }
	}
	
	else
	{ for(N=-Nmax;N<=Nmax;N++)
	  for(sign=1.0,m=-abs(N);m>=-l;sign=-sign,m--)
	  { d[N][m]=sign*d[-N][-m];
	    if(abs(m)<=Nmax)
	    { d[-m][-N]=d[N][m];
	      d[m][N]=d[-N][-m];
	    }
	  }
	}
}
