#include <stdio.h>

#define STOP(x) {printf("\n x \n"); exit();}
#define stop(x) {printf("\n" x "\n"); exit(99);}

#define RADIUS  6371.0
#define PI   3.14159265358979312
#define D double
#define F float

#define MAXS 64

extern float *farray1();
extern float spl();
extern void free_farray1();

/******************************************/
void main()
{
  char string[40];
  float *coef;
  FILE *fp,*A1pf;
  int maxs,dummy,nku,nkl,nknots;
  int ndis,rmax,jump,hmax,mdim,vjump,i,p,nn;
  float mindep,maxdep,fac,x,r,*mdl,*knot;

  if((fp=fopen("QRLW8.A1d","r"))==0)
    STOP(QA1grid: Cannot open model file);
  fscanf(fp,"%d %d %d %d %d",&maxs,&dummy,&nku,&nkl,&ndis);
  if(maxs>MAXS) STOP(gridA1d_q3: maxs too large);
  if((A1pf=fopen("QRLW8.spline7.par","r"))==0)
    STOP(QA1grid: Cannot open A1.par file);

 
  ndis=0;

  printf("\n");
  fscanf(A1pf,"%d",&nknots);
  if(nknots!=nku+nkl+2)
    STOP(gridA1d_q3: knot information inconsistent); 
  knot=farray1(0,nknots-1);
  for(i=0;i<nknots;i++)fscanf(A1pf,"%f",&knot[i]);   
    
  fclose(A1pf);

  mindep=RADIUS-knot[nknots-1];
  maxdep=RADIUS-knot[0];
 
  printf(" Depth range: [%.3f %3.f] km", 
	 mindep,maxdep);

  hmax=(maxs+1)*(maxs+1);
  mdim=hmax*(ndis+nknots);
  mdl=farray1(0,mdim-1);
  for(i=0;i<mdim;i++) fscanf(fp,"%g",&mdl[i]);
  fclose(fp);
  
  vjump=hmax*nknots;
  coef=farray1(0,hmax-1);

 do {
    printf(" Specify a depth,"); 
    printf(" or 'q' to quit: ");

    scanf("%s",string);
    if(string[0]=='q')break;
    else  {
      sscanf(string,"%f",&r);
      if(r<mindep||r>maxdep) STOP(QA1grid: error! depth not in model range);
      r=RADIUS-r;      
      jump=0;            
      for(i=0;i<hmax;i++) coef[i]=0.;
      for(p=0;p<nknots;p++){
        fac=1000*spl(p,nknots,knot,r); /* d(1/2Q)x1000 */
        for(i=0;i<hmax;i++) 
	  coef[i]+=fac*mdl[jump+i+p*hmax];	
      }
    }
    if(string[0]!='q')string[0]='\0';
    harmogrid1(maxs,coef,"X^");
  } while(string[0]!='q');

  free_farray1(mdl,0);
  free_farray1(coef,0);
}
