//  -*- Mode: C++;  -*-

//  File: surf2arc.cpp

//  Author: Dino Bellugi (dino@geomorph.berkeley.edu)

//  Copyright  Dino Bellugi, BlueG SoftWear, U.C. Berkeley, 1999 (C)

// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// * FUNCTION: converts from surfer to arcinfo formats

// *

// * CLASSES: grid

// * 

// * RELATED PACKAGES: grid.cpp

// *

// * HISTORY:

// * Created:  Thu Mar 27 1997 (dino)

// * Modified: Mon May 10 1999 (dino)

// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



// the following include file (notice.h) contains important copyright 

// information, as well as other legal statements. it must be present 

// in all files and in any distribution. removal or modification is

// strictly forbidden and violates u.s. and international copyright law.

#include "notice.h"

char *copyright_notice = "(C) 1999 Dino Bellugi, BlueG SoftWear, U.C. Berkeley";

//

#include <stdio.h>

#include <stdlib.h>

#include <fstream.h>

#include <string.h> 

#include "grid.h"

#include "macros.h"



#define INPUT		0

#define OUTPUT		1

#define MESSAGES	1



main(int argc, char **argv) 

{

	Grid grd;

	int i, j;



	if (argc != 2) 

	{

#if (MESSAGES)

                // invalid arguments, print usage

                cerr << "usage:\n";

                cerr << "\t" << appName(argv) << " <input grid>\n";

                cerr << "example:\n";

                cerr << "\t" << appName(argv) << " surfer.grd > arcinfo.grd\n";

#endif

    		exit(1);

  	}



#if (MESSAGES)

	cerr << "Reading input surfer grid ...\n";

#endif



	if (grd.readGrid(argv[1], INPUT, SURFER) != OK)

		exit(1);



#if (MESSAGES)

        cerr << "Changing nodata value (" << grd.nodata << " to " <<

                DEF_VAL << ") ...\n";

#endif

 

        grd.chgNodata(DEF_VAL, TRUE, INPUT);



#if (MESSAGES)

	cerr << "Initializing output grid ...\n";

#endif



	if (grd.addField() != OK)

		exit(1);



#if (MESSAGES)

	cerr << "Converting grid (" << grd.ydim << " rows, " << grd.xdim <<

		" columns) ...\n";

#endif



	for (i = 0; i < grd.xdim; ++i)

	{

		for (j = 0; j < grd.ydim; ++j)

		{

			grd.at(i, j, OUTPUT) = 

				grd.at(i, grd.ydim - j - 1, INPUT);

		}

	}  



#if (MESSAGES)

	cerr << "Writing output arcinfo grid ...\n";

#endif

	grd.coutGrid(OUTPUT, ARCINFO);



        exit(FALSE);    

        return(TRUE);

}

