//  -*- Mode: C++;  -*-

//  File: slope.cpp

//  Author: Dino Bellugi (dino@geomorph.berkeley.edu)

//  Copyright  Dino Bellugi, BlueG SoftWear, U.C. Berkeley, 1999 (C)

// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// * FUNCTION:	Calculates the slope value at each cell

// *		of an elevation grid. 

// *

// * RELATED PACKAGES: stabfun.cpp grid.cpp

// *

// * HISTORY:

// * Created:	Tue Mar 23 1999 (dino)

// * Modified:	Mon May 10 1999 (dino)

// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



// the following include file (notice.h) contains important copyright 

// information, as well as other legal statements. it must be present 

// in all files and in any distribution. removal or modification is

// strictly forbidden and violates u.s. and international copyright law.

#include "notice.h"

char *copyright_notice = "(C) 1999 Dino Bellugi, BlueG SoftWear, U.C. Berkeley";

//

#include "stabfun.h"

#include "macros.h"



#define MESSAGES	1



int main (int argc, char **argv) 

{

	int mode, type;



        if (argc < 2 || argc > 4)

        {

#if (MESSAGES)

                // invalid arguments, print usage

		cerr << "usage:\n";

                cerr << "\t" << appName(argv) << " <elevation grid> [<format> "

		     << "<mode>]\n";

                cerr << "formats:\n";

                cerr << "\t0 = arcinfo ascii (default)\n";

                cerr << "\t1 = surfer ascii\n";

                cerr << "modes:\n";

                cerr << "\t0 = theta, radians (default)\n";

                cerr << "\t1 = tan(theta)\n";

                cerr << "\t2 = sin(theta)\n";

                cerr << "\t3 = cos(theta)\n";

//              cerr << "\t4 = theta, degrees\n";

//              cerr << "\t5 = tan(theta), degrees\n";

                cerr << "example:\n";

                cerr << "\t" << appName(argv) << " elev.grd > slope.grd\n";

#endif

                exit(1);

        }

 

        if (argc < 3 || (type = atoi(argv[2])) <= 0 || type > 1)

                type = ARCINFO;

	else

		type = SURFER;



//      if (argc < 4 || (mode = atoi(argv[3])) < 0 || mode > 5)
        if (argc < 4 || (mode = atoi(argv[3])) < 0 || mode > 3)

                mode = ATAN_RAD;



	do_Slope(argv[1], (char *)NULL, type, mode, MESSAGES);



        exit(FALSE);    

        return(TRUE);

}

