//  -*- Mode: C++;  -*-

//  File: shalstabcf.cpp

//  Author: Dino Bellugi (dino@geomorph.berkeley.edu)

//  Copyright  Dino Bellugi, BlueG SoftWear, U.C. Berkeley, 1999 (C)

// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// * FUNCTION: computes q/T as well as sink removed, slope, 

// *	area grids, using cohesion and constant soil depth

// *

// * RELATED PACKAGES: stabfun.cpp area_class.cpp grid.cpp gridedges.cpp

// *

// * HISTORY:

// * Created:  Thu Apr  1 1999 (dino)

// * Modified: Mon May 10 1999 (dino)

// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



// the following include file (notice.h) contains important copyright 

// information, as well as other legal statements. it must be present 

// in all files and in any distribution. removal or modification is

// strictly forbidden and violates u.s. and international copyright law.

#include "notice.h"

char *copyright_notice = "(C) 1999 Dino Bellugi, BlueG SoftWear, U.C. Berkeley";

//

#include "stabfun.h"

#include "macros.h"



#define MESSAGES	1



int main (int argc, char **argv) 

{

	int type;

	char *rem = (char *)NULL, *slp = (char *)NULL, *area = (char *)NULL;



        if (argc < 6 || argc > 10)

        {

#if (MESSAGES)

                // invalid arguments, print usage

		cerr << "usage:\n";

                cerr << "\t" << appName(argv) << " <elevation grid> <saturation "

		     << "constant> <critical angle> <soil depth> <cohesion> [<format> "

		     << "<sink removed grid> <slope grid> <area grid>]\n";

                cerr << "formats:\n";

                cerr << "\t0 = arcinfo ascii (default)\n";

                cerr << "\t1 = surfer ascii\n";

                cerr << "examples:\n";

                cerr << "\t" << appName(argv) << " elev.grd 1700 45 1.0 2000 > qovert.grd\n";

                cerr << "\t" << appName(argv) << " elev.grd 1700 45 1.0 2000 0 remove.grd "

		     << "slope.grd area.grd > qovert.grd\n";

#endif

                exit(1);

        }



        if (argc < 7 || (type = atoi(argv[6])) <= 0 || type > 1)

                type = ARCINFO;

	else

		type = SURFER;



	if (argc >= 8)

		rem = argv[7];



	if (argc >= 9)

		slp = argv[8];



	if (argc >= 10)

		area = argv[9];



	do_ShalstabCF(argv[1], rem, slp, area, (char *)NULL, 

		type, (float)RS_INCREMENT, (float)atof(argv[2]), 

		(float)atof(argv[3]), (float)atof(argv[4]), 

		(float)atof(argv[5]), MESSAGES);



        exit(FALSE);    

        return(TRUE);

}

