//  -*- Mode: C++;  -*-

//  File: removesinks.cpp

//  Author: Dino Bellugi (dino@geomorph.berkeley.edu)

//  Copyright  Dino Bellugi, BlueG SoftWear, U.C. Berkeley, 1999 (C)

// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// * FUNCTION:  removes sinks from an elevation grid

// *

// * RELATED PACKAGES: grid.cpp stabfun.cpp

// *

// * HISTORY:

// * Created:   Tue Apr 27 1993 (dino, based on rob reiss' version)

// * Modified:  Wed Jan 20 1999 (dino)

// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



// the following include file (notice.h) contains important copyright 

// information, as well as other legal statements. it must be present 

// in all files and in any distribution. removal or modification is

// strictly forbidden and violates u.s. and international copyright law.

#include "notice.h"

char *copyright_notice = "(C) 1999 Dino Bellugi, BlueG SoftWear, U.C. Berkeley";

//

#include "stabfun.h"

#include "macros.h"



#define MESSAGES        1



int main (int argc, char **argv) 

{

	int type, pass;

	double incr;



	// Get the arguments from the command line.

	if (argc < 2 || argc > 5) 

	{

#if (MESSAGES)

                // invalid arguments, print usage

		cerr << "usage:\n";

                cerr << "\t" << appName(argv) << " <elevation grid> [<format>"

		     << " <max. passes> <increment>]\n";

                cerr << "formats:\n";

                cerr << "\t0 = arcinfo ascii (default)\n";

                cerr << "\t1 = surfer ascii\n";

                cerr << "defaults:\n";

		cerr << "\televation increment = 0.1m\n";

		cerr << "\tmaximum passes = 100\n";

                cerr << "example:\n";

                cerr << "\t" << appName(argv) << " elev.grd > remove.grd\n";

#endif

                exit(1);

	}



        if (argc < 3 || (type = atoi(argv[2])) <= 0 || type > 1)

                type = ARCINFO;

	else

		type = SURFER;



	if (argc < 4 || (incr = atof(argv[3])) <= 0.0)

		incr = RS_INCREMENT;



	if (argc < 5 || (pass = atoi(argv[4])) < 1)

		pass = RS_MAXPASSES;



	do_RemoveSinks(argv[1], (char *)NULL, type, (float)incr, pass, MESSAGES);



        exit(FALSE);    

        return(TRUE);

}

