//  -*- Mode: C++;  -*-
//  File: joeldata.cc
//  Author: Dino Bellugi (dino@geomorph.berkeley.edu)
//  Copyright  Dino Bellugi, BlueG SoftWear, U.C. Berkeley, 2001 (C)
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// * FUNCTION: extract, contructs an excel-type table from a series 
// * of ascii files based on the command line parameters
// *
// * RELATED PACKAGES: profile.cpp
// *
// * HISTORY:
// * Created:  Tue Jul 10 2001 (dino)
// * Modified: 
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// the following include file (notice.h) contains important copyright 
// information, as well as other legal statements. it must be present 
// in all files and in any distribution. removal or modification is
// strictly forbidden and violates u.s. and international copyright law.

// define the OS here
#ifndef NO_WIN
#ifndef WIN
#define WIN
#endif
#endif

#include "notice.h"
char *copyright_notice = "(C) 2001 Dino Bellugi, BlueG SoftWear, U.C. Berkeley";
//
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fstream.h>
#include <math.h>
#include "macros.h"
#include "profile.h"

#define	VAR_SIZE	256
#define	BUF_SIZE	65536
#define	VAR_SKIP	3
#define VAR_DEF		0.0

main(int argc, char **argv) 
{
	int l, m, n, pars, lines, files;
	long tot = 0L;
	char *group[VAR_SIZE], *filenames[VAR_SIZE], string[BUF_SIZE];
	double *column[VAR_SIZE][VAR_SIZE];

	// Check the command line.
	if (argc < 2 || argc <= (VAR_SKIP + (pars = atoi(argv[1]))))
	{

    		// Problem With input
    		cerr << "usage:\n\t" << appName(argv) <<
			" <variables> <lines> <group1> [<group2> ...] <file list>\n";
                cerr << "example:\n\t";
                cerr << appName(argv) <<
			" 2 10 group1 group2 files.* > table.txt\n";
    		return(1);
  	}

	// read the parameters
	lines = atoi(argv[2]);
	for (n = 0; n < pars; ++n)
		group[n] = argv[n + VAR_SKIP];
	for (n = 0, files = argc - pars - VAR_SKIP; n < files; ++n)
		filenames[n] = argv[n + pars + VAR_SKIP];

	// allocate memory
	for (n = 0; n < files; ++n)
	{
		for (m = 0; m < pars; ++m)
		{
			if ((column[n][m] = (double *)malloc(lines * sizeof(double))) == 
				(double *)NULL)
			{
				cerr << "Can't allocate memory, exiting ...\n";
				exit(1);
			}
			// initialize to default value
			for (l = 0; l < lines; ++l)
				*(column[n][m] + l) = VAR_DEF;
		}
	}

	// read data
	for (n = 0; n < files; ++n)
	{
		for (m = 0; m < pars; ++m)
		{
			if (!readPrivateProfileDoubleColumn(filenames[n], group[m], 
				lines, column[n][m], VAR_DEF))
			{
				cerr << "read error: file " << filenames[n] << ", group " <<
					group[m] << ", " << lines << " lines\n";
				exit(1);
			}
		}
	}

	// write output table
	cerr << "Writing output table ...\n";

	// write header
	for (n = 0; n < files ; ++n)
	{
		for (m = 0; m < pars ; ++m)
		{
			sprintf(string, "%s_%s", filenames[n], group[m]);
			cout << string << "\t";
		}
	}
	cout << "\n";

	// write data
	for (l = 0; l < lines; ++l)
	{
		for (n = 0; n < files; ++n)
		{
			for (m = 0; m < pars; ++m)
			{
				cout << *(column[n][m] + l) << "\t";
			}
		}
		cout << "\n";
	}

	// free memory
	for (n = 0; n < files; ++n)
		for (m = 0; m < pars; ++m)
			free(column[n][m]);

	// Done
	cerr << appName(argv) << ": done creating table!\n";
	return(0);
}
