//  -*- Mode: C++;  -*-

//  File: square.cpp

//  Author: Dino Bellugi (dino@geomorph.berkeley.edu)

//  Copyright  Dino Bellugi, BlueG SoftWear, U.C. Berkeley, 1999 (C)

// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// * FUNCTION: clips input grid to a square grid

// *

// * RELATED PACKAGES: grid.cpp

// *

// * HISTORY:

// * Created:  Wed Nov 10 1999 (dino)

// * Modified: 

// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



// the following include file (notice.h) contains important copyright 

// information, as well as other legal statements. it must be present 

// in all files and in any distribution. removal or modification is

// strictly forbidden and violates u.s. and international copyright law.

#include "notice.h"

char *copyright_notice = "(C) 1999 Dino Bellugi, BlueG SoftWear, U.C. Berkeley";

//


#include "stabfun.h"


main(int argc, char **argv) 

{

	Grid grd;

	int i, j, size, type;


	// Get the file names from the command line.

	if (argc < 2 || argc > 3)

	{

    		// Problem With input

    		cerr << "usage:\n\t" << appName(argv) <<

			" <input grid> [<format>]\n";

                cerr << "formats:\n";

                cerr << "\t0 = arcinfo ascii (default)\n";

                cerr << "\t1 = surfer ascii\n";

                cerr << "example:\n\t";

                cerr << appName(argv) << " elev.grid > square.grid\n";

    		exit(1);

  	}



	// Get format

    if (argc != 3 || (type = atoi(argv[2])) <= 0 || type > 1)

                type = ARCINFO;

	else

		type = SURFER;



	// Read input grid

	cerr << "Reading input grid ...\n";

	if (grd.readGrid(argv[1]) != OK)

	{

		cerr << appName(argv) << ": error reading " << argv[1] << " ...\n";

		exit(1);

	}

	size = min(grd.xdim, grd.ydim);

	Grid square(size, size, grd.xorg, grd.yorg, grd.spacing, grd.nodata);
	
	cerr << "Creating output grid ...\n";

	for (j = 0; j < size; ++j)

		for (i = 0; i < size; ++i)

			square.at(i, j) = grd.at(i, j);

	// Write output grids

	cerr << "Writing output grid ...\n";

	square.coutGrid(0, type);

	exit(FALSE);    

	return(TRUE);

}

