//  -*- Mode: C++;  -*-
//  File: mkxyz.cc
//  Author: Dino Bellugi (dino@geomorph.berkeley.edu)
//  Copyright  Dino Bellugi, BlueG SoftWear, U.C. Berkeley, 2000 (C)
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// * FUNCTION: mkxyz, converts an ascii grid into an xyz file
// *
// * RELATED PACKAGES: grid.cc
// *
// * HISTORY:
// * Created:  Fri Jun 18 1999 (dino)
// * Modified: Sat Jun 26 1999 (dino)
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// the following include file (notice.h) contains important copyright 
// information, as well as other legal statements. it must be present 
// in all files and in any distribution. removal or modification is
// strictly forbidden and violates u.s. and international copyright law.
#include "notice.h"
char *copyright_notice = "(C) 2000 Dino Bellugi, BlueG SoftWear, U.C. Berkeley";
//
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fstream.h>
#include <math.h>
#include "grid.h"
#include "macros.h"

main(int argc, char **argv) 
{
	Grid grd;
	int i, j, type;
	long tot = 0L;

	// Get the file names from the command line.
	if (argc < 2 || argc > 3)
	{
    		// Problem With input
    		cerr << "usage:\n\t" << appName(argv) <<
			" <grid> [<format>]\n";
                cerr << "formats:\n";
                cerr << "\t0 = arcinfo ascii (default)\n";
                cerr << "\t1 = surfer ascii\n";
                cerr << "example:\n\t";
                cerr << appName(argv) << " elev.grd > xyz.txt\n";
    		return(1);
  	}

	// Get format
        if (argc == 2 || (type = atoi(argv[2])) != 1)
                type = ARCINFO;
	else
		type = SURFER;

	// Read input grid
	cerr << "Reading input grid ...\n";
	if (grd.readGrid(argv[1], 0, type) != OK)
	{
		cerr << appName(argv) << ": error reading " <<
			argv[1] << " ...\n";
		return(1);
	}

	cerr << "Writing output file ...\n";

	// Scan input grid
	for (j = 0; j < grd.ydim; ++j)
	{
		for (i = 0; i < grd.xdim; ++i)
		{
			// Write data
			cout << i * grd.spacing + grd.xorg
				 << SEPARATOR
				 << i * grd.spacing + grd.xorg
				 << SEPARATOR
				 << grd.at(i,j)
				 << "\n";
			++tot;
		}
	}  

	// Done
	cerr << appName(argv) << ": done creating file, " <<
		tot << " records written!\n";
	return(0);
}
