//  -*- Mode: C++;  -*-
//  File: extract.cc
//  Author: Dino Bellugi (dino@geomorph.berkeley.edu)
//  Copyright  Dino Bellugi, BlueG SoftWear, U.C. Berkeley, 2000 (C)
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// * FUNCTION: extract, contructs an excel-type table from a series 
// * of ascii files based on the command line parameters
// *
// * RELATED PACKAGES: profile.cc
// *
// * HISTORY:
// * Created:  Tue Nov 14 2000 (dino)
// * Modified: 
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// the following include file (notice.h) contains important copyright 
// information, as well as other legal statements. it must be present 
// in all files and in any distribution. removal or modification is
// strictly forbidden and violates u.s. and international copyright law.

// define the OS here
#ifndef NO_WIN
#ifndef WIN
#define WIN
#endif
#endif

#include "notice.h"
char *copyright_notice = "(C) 2000 Dino Bellugi, BlueG SoftWear, U.C. Berkeley";
//
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fstream.h>
#include <math.h>
#include "macros.h"
#include "profile.h"

#define	MAX_VARS	100
#define	MAX_COLUMN	65536
#define	BUF_SIZE	1000
#define	SKIP		2

main(int argc, char **argv) 
{
	int i, j, n, m, num, pars;
	long tot = 0L;
	char *file, *group[MAX_VARS], *variable[MAX_VARS], string[BUF_SIZE];
	double column[MAX_COLUMN];

	// Check the command line.
	if (argc < 2 || argc <= (num = SKIP + 2 * (pars = atoi(argv[1]))))
	{

    		// Problem With input
    		cerr << "usage:\n\t" << appName(argv) <<
			" <variables> <group1> <var1> [<group2> <var2> ...] <file list>\n";
                cerr << "example:\n\t";
                cerr << appName(argv) <<
			" 2 group1 var1 group2 var2 files.* > table.txt\n";
    		return(1);
  	}

/*
	// Allocate memory
	for (n = 0; n < pars; ++n)
	{
		if ((group[n] = new char[BUF_SIZE]) == (char *)NULL) ||
			(variable[n] = new char[BUF_SIZE]) == (char *)NULL) ||
			(string[n] = new char[BUF_SIZE]) == (char *)NULL))
		{
			cerr << appName(argv) << ": can't allocate memory!\n";
			return(1);
		}
	}
*/

	// read the parameters
	for (n = 0; n < pars; ++n)
	{
		group[n] = argv[2 * n + SKIP];
		variable[n] = argv[2 * n + SKIP + 1];
	}

	cerr << "Writing output table ...\n";
	cout << "File";
	for (m = 0; m < pars; ++m)
	{
		sprintf(string, "%s_%s", group[m], variable[m]);
		cout << "\t" << string;
	}
	cout << "\n";

	// n : files loop, m : parameters loop
	for (n = num; n < argc; ++n)
	{
		file = argv[n];
		cout << file;
		for (m = 0; m < pars; ++m)
		{
//			if ((i = atoi(variable[m])) > 0 && i <= MAX_COLUMN)
//			{
//				readPrivateProfileColumn(file, group[m], i, column, MAX_COLUMN, 0);
//				for (j = 0; j < i; ++j)
//					cout << "\t" << column[j];
//			}
//			else
			{
				readPrivateProfileString(file, group[m], variable[m], 
					string, BUF_SIZE, "");
				cout << "\t" << string;
			}
		}
		cout << "\n";
	}

	// Done
	cerr << appName(argv) << ": done creating table!\n";
	return(0);
}
