//  -*- Mode: C++;  -*-
//  File: dist2out.cc
//  Author: Dino Bellugi (dino@geomorph.berkeley.edu)
//  Copyright  Dino Bellugi, BlueG SoftWear, U.C. Berkeley, 2000 (C)
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// * FUNCTION:  computes distance to outlet as well as sink removed, 
//* 		and flow direction grids
// *
// * RELATED PACKAGES: stabfun.cc grid.cc
// *
// * HISTORY:
// * Created:  Thu Jun 15 2000 (dino)
// * Modified: 
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// the following include file (notice.h) contains important copyright 
// information, as well as other legal statements. it must be present 
// in all files and in any distribution. removal or modification is
// strictly forbidden and violates u.s. and international copyright law.
#include "notice.h"
char *copyright_notice = "(C) 2000 Dino Bellugi, BlueG SoftWear, U.C. Berkeley";
//
#include "stabfun.h"
#include "macros.h"

#define MESSAGES	1
#define INCREMENT	0.01
#define MAXPASSES	100

int main (int argc, char **argv) 
{
	int type;
	char *rem = (char *)NULL, *flw = (char *)NULL;

        if (argc < 2 || argc > 5)
        {
#if (MESSAGES)
                // invalid arguments, print usage
		cerr << "usage:\n";
                cerr << "\t" << appName(argv) << " <elevation grid> "
		     << "[<format> <sink removed grid> "
		     << "<flow direction grid>]\n";
                cerr << "formats:\n";
                cerr << "\t0 = arcinfo ascii (default)\n";
                cerr << "\t1 = surfer ascii\n";
                cerr << "examples:\n";
                cerr << "\t" << appName(argv) << " elev.grd > dist2out.grd\n";
                cerr << "\t" << appName(argv) << " elev.grd 0 remove.grd "
		     << "flowdir.grd > dist2out.grd\n";
#endif
                exit(1);
        }

        if (argc < 3 || (type = atoi(argv[2])) <= 0 || type > 1)
                type = ARCINFO;
	else
		type = SURFER;

	if (argc >= 4)
		rem = argv[3];

	if (argc >= 5)
		flw = argv[4];

	do_ChDist2Out(argv[1], rem, flw, (char *)NULL, type, type,
		INCREMENT, MAXPASSES, MESSAGES);

	return(OK);
}
