//  -*- Mode: C++;  -*-

//  File: curvature.cpp

//  Author: Dino Bellugi (dino@geomorph.berkeley.edu)

//  Copyright  Dino Bellugi, BlueG SoftWear, U.C. Berkeley, 1999 (C)

// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// * FUNCTION:	Calculates the curvature value at each cell

// *		of an elevation grid. 

// *

// * RELATED PACKAGES: stabfun.cpp grid.cpp

// *

// * HISTORY:

// * Created:	Tue Mar 23 1999 (dino)

// * Modified:	Mon May 10 1999 (dino)

// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



// the following include file (notice.h) contains important copyright 

// information, as well as other legal statements. it must be present 

// in all files and in any distribution. removal or modification is

// strictly forbidden and violates u.s. and international copyright law.

#include "notice.h"

char *copyright_notice = "(C) 1999 Dino Bellugi, BlueG SoftWear, U.C. Berkeley";

//

#include "stabfun.h"

#include "macros.h"



#define MESSAGES	1



int main (int argc, char **argv) 

{

	int type;



        if (argc < 2 || argc > 3)

        {

#if (MESSAGES)

                // invalid arguments, print usage

		cerr << "usage:\n";

                cerr << "\t" << appName(argv) << " <elevation grid> [<format>]\n";

                cerr << "formats:\n";

                cerr << "\t0 = arcinfo ascii (default)\n";

                cerr << "\t1 = surfer ascii\n";

                cerr << "example:\n";

                cerr << "\t" << appName(argv) << " elev.grd > curv.grd\n";

#endif

                exit(1);

        }

 

        if (argc < 3 || (type = atoi(argv[2])) <= 0 || type > 1)

                type = ARCINFO;

	else

		type = SURFER;



	do_Curvature(argv[1], (char *)NULL, type, MESSAGES);



        exit(FALSE);    

        return(TRUE);

}

