//  -*- Mode: C++;  -*-

//  File: arcdir2turtle.cpp

//  Author: Dino Bellugi (dino@geomorph.berkeley.edu)

//  Copyright  Dino Bellugi, BlueG SoftWear, U.C. Berkeley, 1999 (C)

// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// * FUNCTION: Converts from arcinfo to surfer formats

// * 

// * RELATED PACKAGES: grid.cpp stabfun.cpp

// *

// * HISTORY:

// * Created:  Thu Mar 27 1997 (dino)

// * Modified: Mon May 10 1999 (dino)

// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



// the following include file (notice.h) contains important copyright 

// information, as well as other legal statements. it must be present 

// in all files and in any distribution. removal or modification is

// strictly forbidden and violates u.s. and international copyright law.

#include "notice.h"

char *copyright_notice = "(C) 1999 Dino Bellugi, BlueG SoftWear, U.C. Berkeley";

//


#include "stabfun.h"



#define INPUT		0

#define OUTPUT		1

#define MESSAGES	1



main(int argc, char **argv) 

{

	Grid grd;

	int i, j, val;


	if (argc != 2) 

	{

#if (MESSAGES)

                // invalid arguments, print usage

                cerr << "usage:\n";

                cerr << "\t" << appName(argv) << " <input grid>\n";

                cerr << "example:\n";

                cerr << "\t" << appName(argv) << " arcinfo.grd > surfer.grd\n";

#endif



    		exit(1);

  	}



#if (MESSAGES)

	cerr << "Reading input arcinfo grid ...\n";

#endif



	if (grd.readGrid(argv[1], INPUT, ARCINFO) != OK)

		exit(1);



#if (MESSAGES)

        cerr << "Initializing output grid ...\n";

#endif



        if (grd.addField() != OK)

                exit(1);



#if (MESSAGES)

	cerr << "Converting grid (" << grd.ydim << " rows, " << grd.xdim <<

		" columns) ...\n";

#endif



	for (i = 0; i < grd.xdim; ++i)

	{

		for (j = 0; j < grd.ydim; ++j)

		{

			val = (int)(grd.at(i, j, INPUT));

			switch(val)
			{
				case 1:
					break;
				case 2:
					val = 8;
					break;
				case 4:
					val = 7;
					break;
				case 8:
					val = 6;
					break;
				case 16:
					val = 5;
					break;
				case 32:
					val = 4;
					break;
				case 64:
					val = 3;
					break;
				case 128:
					val = 2;
					break;
				default:
					val = 9;
					break;
			}

			grd.at(i, j, OUTPUT) = (double)val;

		}

	}  



#if (MESSAGES)

	cerr << "Writing output turtle file ...\n";

#endif

	grd.coutGrid(OUTPUT, TURTLE);



        exit(FALSE);    

        return(TRUE);

}

