//  -*- Mode: C++;  -*-
//  File: testsinks.cc
//  Author: Dino Bellugi (dino@geomorph.berkeley.edu)
//  Copyright  Dino Bellugi, BlueG SoftWear, U.C. Berkeley, 1999 (C)
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// * FUNCTION:  tests for sinks in an elevation grid
// *
// * RELATED PACKAGES: grid.cc 
// *
// * HISTORY:
// * Created:  Wed Jan 20 1999 (dino)
// * Modified: Sat Jun 26 1999 (dino)
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// the following include file (notice.h) contains important copyright 
// information, as well as other legal statements. it must be present 
// in all files and in any distribution. removal or modification is
// strictly forbidden and violates u.s. and international copyright law.
#include "notice.h"
char *copyright_notice = "(C) 1999 Dino Bellugi, BlueG SoftWear, U.C. Berkeley";
//
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fstream.h>
#include "grid.h"
#include "macros.h"

#define MESSAGES	2	// 0 = no messages, 1 = totals, 2 = details

main(int argc, char **argv) 
{
	int type;

	// Get the Grid File from the command line.
	if (argc < 2 || argc > 3) 
        { 
#if (MESSAGES)
                // invalid arguments, print usage
                cerr << "usage:\n";
                cerr << "\t" << appName(argv) << " <elevation grid> [<format>]\n";
                cerr << "formats:\n";
                cerr << "\t0 = arcinfo ascii (default)\n";
                cerr << "\t1 = surfer ascii\n";
                cerr << "example:\n";
                cerr << "\t" << appName(argv) << " elev.grd\n";
#endif
    		exit(1);
  	}

        if (argc != 3 || (type = atoi(argv[2])) <= 0 || type > 1)
                type = ARCINFO;
	else
		type = SURFER;

	Grid elv;

	// Read grid(s) and check for sinks
#if (MESSAGES)
	cerr << "Reading elevation grid ...\n";
#endif
	if (!elv.readGrid(argv[1], 0, type))
		exit(1);

#if (MESSAGES)
	cerr << "Checking for sinks ...\n";
#endif
	elv.checkForSinks(0, MESSAGES);

        exit(FALSE);    
        return(TRUE);
}
