//  -*- Mode: C++;  -*-
//  File: shalstab.cc
//  Author: Dino Bellugi (dino@geomorph.berkeley.edu)
//  Copyright  Dino Bellugi, BlueG SoftWear, U.C. Berkeley, 1999 (C)
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// * FUNCTION: computes q/T as well as sink removed, slope, area grids
// *
// * RELATED PACKAGES: stabfun.cc area_class.cc grid.cc gridedges.cc
// *
// * HISTORY:
// * Created:  Thu Apr  1 1999 (dino)
// * Modified: Mon May 10 1999 (dino)
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// the following include file (notice.h) contains important copyright 
// information, as well as other legal statements. it must be present 
// in all files and in any distribution. removal or modification is
// strictly forbidden and violates u.s. and international copyright law.
#include "notice.h"
char *copyright_notice = "(C) 1999 Dino Bellugi, BlueG SoftWear, U.C. Berkeley";
//
#include "stabfun.h"
#include "macros.h"

#define MESSAGES	1

int main (int argc, char **argv) 
{
	int type;
	char *rem = (char *)NULL, *slp = (char *)NULL, *area = (char *)NULL;

        if (argc < 4 || argc > 8)
        {
#if (MESSAGES)
                // invalid arguments, print usage
		cerr << "usage:\n";
                cerr << "\t" << appName(argv) << " <elevation grid> <saturation "
		     << "constant> <critical angle> [<format> <sink removed grid> "
		     << "<slope grid> <area grid>]\n";
                cerr << "formats:\n";
                cerr << "\t0 = arcinfo ascii (default)\n";
                cerr << "\t1 = surfer ascii\n";
                cerr << "examples:\n";
                cerr << "\t" << appName(argv) << " elev.grd 1700 45 > qovert.grd\n";
                cerr << "\t" << appName(argv) << " elev.grd 1700 45 0 remove.grd "
		     << "slope.grd area.grd > qovert.grd\n";
#endif
                exit(1);
        }

        if (argc < 5 || (type = atoi(argv[4])) <= 0 || type > 1)
                type = ARCINFO;
	else
		type = SURFER;

	if (argc >= 6)
		rem = argv[5];

	if (argc >= 7)
		slp = argv[6];

	if (argc >= 8)
		area = argv[7];

	do_Shalstab(argv[1], rem, slp, area, (char *)NULL, type, type,
		RS_INCREMENT, RS_MAXPASSES, atof(argv[2]), atof(argv[3]), MESSAGES);

        exit(FALSE);    
        return(TRUE);
}
