//  -*- Mode: C++;  -*-
//  File: qovert.cc
//  Author: Dino Bellugi (dino@geomorph.berkeley.edu)
//  Copyright  Dino Bellugi, BlueG SoftWear, U.C. Berkeley, 1999 (C)
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// * FUNCTION: computes q/T from area and slope grids
// *
// * RELATED PACKAGES: stabfun.cc area_class.cc grid.cc gridedges.cc
// *
// * HISTORY:
// * Created:  Thu Apr  1 1999 (dino, based on rob reiss aml)
// * Modified: Mon May 10 1999 (dino)
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// the following include file (notice.h) contains important copyright 
// information, as well as other legal statements. it must be present 
// in all files and in any distribution. removal or modification is
// strictly forbidden and violates u.s. and international copyright law.
#include "notice.h"
char *copyright_notice = "(C) 1999 Dino Bellugi, BlueG SoftWear, U.C. Berkeley";
//
#include "stabfun.h"
#include "macros.h"

#define MESSAGES	1

int main (int argc, char **argv) 
{
	int type;

        if (argc < 5 || argc > 6)
        {
#if (MESSAGES)
                // invalid arguments, print usage
		cerr << "usage:\n";
                cerr << "\t" << appName(argv) << " <slope grid> <area grid> "
		     << "<saturation constant> <critical angle> [<format>]\n";
                cerr << "formats:\n";
                cerr << "\t0 = arcinfo ascii (default)\n";
                cerr << "\t1 = surfer ascii\n";
                cerr << "example:\n";
                cerr << "\t" << appName(argv) << " slope.grd area.grd 1700 "
		     << "45 > qovert.grd\n";
#endif
                exit(1);
        }

        if (argc != 6 || (type = atoi(argv[5])) <= 0 || type > 1)
                type = ARCINFO;
	else
		type = SURFER;

	do_QoverT(argv[1], argv[2], (char *)NULL, type, type,
		atof(argv[3]), atof(argv[4]), MESSAGES);

        exit(FALSE);    
        return(TRUE);
}
