//  -*- Mode: C++;  -*-
//  File: mktable.cc
//  Author: Dino Bellugi (dino@geomorph.berkeley.edu)
//  Copyright  Dino Bellugi, BlueG SoftWear, U.C. Berkeley, 1999 (C)
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// * FUNCTION: mktable, contructs an excel-type table from a series 
// * of ascii grids and a control grid to identify location and id
// *
// * RELATED PACKAGES: grid.cc
// *
// * HISTORY:
// * Created:  Fri Jun 18 1999 (dino)
// * Modified: Sat Jun 26 1999 (dino)
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// the following include file (notice.h) contains important copyright 
// information, as well as other legal statements. it must be present 
// in all files and in any distribution. removal or modification is
// strictly forbidden and violates u.s. and international copyright law.
#include "notice.h"
char *copyright_notice = "(C) 1999 Dino Bellugi, BlueG SoftWear, U.C. Berkeley";
//
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fstream.h>
#include <math.h>
#include "grid.h"
#include "macros.h"

#define CTRL	0
#define DATA	1
#define SKIP	2

main(int argc, char **argv) 
{
	Grid grd;
	int i, j, n, type;
	long tot = 0L;
	char name[80], *p;

	// Get the file names from the command line.
	if (argc < 4)
	{
    		// Problem With input
    		cerr << "usage:\n\t" << appName(argv) <<
			" <format> <control grid> <data grids ...>\n";
                cerr << "formats:\n";
                cerr << "\t0 = arcinfo ascii (default)\n";
                cerr << "\t1 = surfer ascii\n";
                cerr << "example:\n\t";
                cerr << appName(argv) <<
			" points.grd elev.grd slope.grid area.grd > table.txt\n";
    		exit(1);
  	}

	// Get format
        if ((type = atoi(argv[1])) <= 0 || type > 1)
                type = ARCINFO;
	else
		type = SURFER;

	// Read control grid
	cerr << "Reading control grid ...\n";
	if (!grd.readGrid(argv[2], CTRL, type))
	{
		cerr << appName(argv) << ": error reading " <<
			argv[2] << " ...\n";
		exit(1);
	}

	for (n = 0; n < argc - (SKIP + 1); ++n)
	{
		if (!grd.addField())
        	{
                	cerr << appName(argv) <<
				": insufficient memory!\n";
                	exit(1);
        	}

	        // Read data grids
        	cerr << "Reading data grid " << n + 1 << " ...\n";
        	if (!grd.readGrid(argv[n + (SKIP + 1)], DATA + n, type))
        	{
                	cerr << appName(argv) << ": error reading " <<
                        	argv[n] << " ...\n";
                	exit(1);
        	}
	}
 
	cerr << "Writing output table ...\n";

	// Write header (filenames without the trailing extension)
	for (n = SKIP; n < argc; ++n)
	{
		// Strip extensions from file name
		if ((p = strchr(strcpy(name, argv[n]), '.')) != (char *)NULL)
			*p = '\0';
		// Write field name
		cout << name << "\t";
	}
	cout << "\n";

	// Scan control grid
	for (j = 0; j < grd.ydim; ++j)
	{
		for (i = 0; i < grd.xdim; ++i)
		{
			// Write data
			if (grd.isValue(i, j))
			{
        			for (n = 0; n < argc - SKIP; ++n)
				{
                			cout << grd.at(i, j, n) << "\t";
				}
        			cout << "\n";
				++tot;
			}
		}
	}  

	// Done
	cerr << appName(argv) << ": done creating table, " <<
		tot << " records written!\n";

        exit(FALSE);    
        return(TRUE);
}
