//  -*- Mode: C++;  -*-
//  File: stabfun.h
//  Author: Dino Bellugi (dino@geomorph.berkeley.edu)
//  Copyright  Dino Bellugi, BlueG SoftWear, U.C. Berkeley, 1999 (C)
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// * FUNCTION: main interface for shalstab library. functions include
// *           sink removal, computation of A/b, slope, q/T, curvature
// *
// * RELATED PACKAGES: area_class.cpp grid.cpp gridedges.cpp
// *
// * HISTORY:
// * Created:  Thu Apr  1 18:15:00 1999 (dino)
// * Modified: Mon May 10 17:40:00 1999 (dino)
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// the following include file (notice.h) contains important copyright 
// information, as well as other legal statements. it must be present 
// in all files and in any distribution. removal or modification is
// strictly forbidden and violates u.s. and international copyright law.
#include "notice.h"
//
#include <stdlib.h>
#include <stdio.h>
#include <fstream.h>
#include <math.h>
#include <string.h>
#include "grid.h"
#include "area_class.h"
#include "macros.h"

#define ELEV	0
#define REMOVE	1
#define SLOPE	2
#define AREA	3
#define QOVERT	4
#define FIELDS	5

// Removes Sinks
void calcRemoveSinks(Grid *grd, int rem_field, double soil_incr = RS_INCREMENT,
	int rem_max_pass = RS_MAXPASSES, int disp_mode = RS_MESSAGES); 
int do_RemoveSinks(char *elv_grid, char *rem_grid = (char *)NULL,
	int in_grid_mode = ARCINFO, int out_grid_mode = ARCINFO,
	double soil_incr = RS_INCREMENT, int rem_max_pass = RS_MAXPASSES,
	int disp_mode = RS_MESSAGES);

// Calculates Slope 
void calcSlope(Grid *grd, int rem_field, int slp_field, 
	int slp_mode = ATAN_RAD, int disp_mode = GR_MESSAGES); 
int do_Slope(char *rem_grid, char *slp_grid = (char *)NULL,
	int in_grid_mode = ARCINFO,
        int out_grid_mode = ARCINFO, int slp_mode = ATAN_RAD,
	int disp_mode = GR_MESSAGES);

// Calculates Curvature 
void calcCurvature(Grid *grd, int rem_field, int crv_field, 
	int disp_mode = GR_MESSAGES); 
int do_Curvature(char *rem_grid, char *crv_grid = (char *)NULL,
	int in_grid_mode = ARCINFO, int out_grid_mode = ARCINFO,
	int disp_mode = GR_MESSAGES);

// Calculates Area
void calcArea(Grid *grd, int rem_field, int area_field,
	int area_mode = CA_MODE, int check_sinks = TRUE,
	int disp_mode = GR_MESSAGES);
int do_Area(char *rem_grid, char *area_grid = (char *)NULL,
	int in_grid_mode = ARCINFO, int out_grid_mode = ARCINFO, 
        int area_mode = CA_MODE, int check_sinks = TRUE,
	int disp_mode = GR_MESSAGES);
 
// Calculates q/T
void calcQoverT(Grid *grd, int slp_field, int area_field,
	int qt_field, double qt_ps = QT_PS, double qt_phi = QT_PHI,
	int disp_mode = GR_MESSAGES); 
int do_QoverT(char *slp_grid, char *area_grid, char *qt_grid = (char *)NULL,
        int in_grid_mode = ARCINFO, int out_grid_mode = ARCINFO,
        double qt_ps = QT_PS, double qt_phi = QT_PHI,
	int disp_mode = GR_MESSAGES);

// Calculates all
int do_Shalstab(char *elv_grid, char *rem_grid, char *slp_grid,
	char *area_grid, char *qt_grid = (char *)NULL,
	int in_grid_mode = ARCINFO, int out_grid_mode = ARCINFO,
	double soil_incr = RS_INCREMENT, int rem_max_pass = RS_MAXPASSES,
	double qt_ps = QT_PS, double qt_phi = QT_PHI,
	int disp_mode = GR_MESSAGES);
