//  -*- Mode: C++;  -*-
//  File: profile.h
//  Author: Dino Bellugi (dino@geomorph.berkeley.edu)
//  Copyright  Dino Bellugi, BlueG SoftWear, U.C. Berkeley, 1999 (C)
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// * FUNCTION: windows-like profile functions for ".ini" files
// *
// * RELATED PACKAGES: 
// *
// * HISTORY:
// * Created:  Mon Apr 28 1997 (dino)
// * Modified: Sat Jun 26 1999 (dino)
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// the following include file (notice.h) contains important copyright 
// information, as well as other legal statements. it must be present 
// in all files and in any distribution. removal or modification is
// strictly forbidden and violates u.s. and international copyright law.
#include "notice.h"
//
#ifndef	PROF_HDR
#define	PROF_HDR
#define iswhite(c)		((c) == ' ' || (c) == '\t')
#define	INI_FILE		"geo.ini"
#define	BAK_FILE		"geo.bak"
#define PRF_EXT			".ini"
#define BAK_EXT			".bak"
#define LINE_SIZE		128
#define NAME_SIZE		64
#define TEMP_SIZE		16
#define SEEK_BEG		0
#define SEEK_CUR		1
#define SEEK_END		2
#define TRUE			1
#define FALSE			0
#define nextLine(fp)	{char c; while((c = fgetc(fp)) != '\n' && c != EOF);}

int readProfileString(char *pAppName, char *pKeyName, char *pString, int nSize, 
	char *pDefault = (char *)NULL);
int readProfileInt(char *pAppName, char *pKeyName, int *pNum, int nDefault = 0);
int readProfileDouble(char *pAppName, char *pKeyName, double *pDbl,
	double dDefault = 0.0);

int writeProfileString(char *pAppName, char *pKeyName, char *pString);
int writeProfileInt(char *pAppName, char *pKeyName, int nNum);
int writeProfileDouble(char *pAppName, char *pKeyName, double dNum);

int readPrivateProfileString(char *pFileName, char *pAppName, char *pKeyName, 
	char *pString, int nSize, char *pDefault = (char *)NULL);
int readPrivateProfileInt(char *pFileName, char *pAppName, char *pKeyName,
	int *pNum, int  nDefault = 0);
int readPrivateProfileDouble(char *pFileName, char *pAppName, char *pKeyName, 
	double *pDbl, double dDefault = 0.0);

int writePrivateProfileString(char *pFileName, char *pAppName, char *pKeyName, 
	char *pString);
int writePrivateProfileInt(char *pFileName, char *pAppName, char *pKeyName, 
	int nNum);
int writePrivateProfileDouble(char *pFileName, char *pAppName, char *pKeyName, 
	double dNum);

int findAppName(FILE *fp, char *name);
int findKeyName(FILE *fp, char *name);
int backupFile(FILE *ofp, FILE *ifp, int mode);

#endif
