//  -*- Mode: C++;  -*-
//  File: stabfun.h
//  Author: Dino Bellugi (dino@geomorph.berkeley.edu)
//  Copyright  Dino Bellugi, BlueG SoftWear, U.C. Berkeley, 1999 (C)
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// * FUNCTION: main interface for shalstab library. functions include
// *           sink removal, computation of A/b, slope, q/T, curvature
// *
// * RELATED PACKAGES: area_class.cpp grid.cpp gridedges.cpp
// *
// * HISTORY:
// * Created:  Thu Apr  1 18:15:00 1999 (dino)
// * Modified: Mon May 10 17:40:00 1999 (dino)
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#ifndef	DEF_STABFUN
#define	DEF_STABFUN

// the following include file (notice.h) contains important copyright 
// information, as well as other legal statements. it must be present 
// in all files and in any distribution. removal or modification is
// strictly forbidden and violates u.s. and international copyright law.

#include "notice.h"

// define the OS here
#ifndef NO_WIN
#ifndef WIN
#define WIN
#endif
#endif

// define other platforms and interfaces here
#ifndef NO_ARCVIEW
#ifndef AV_GIO_API
#define AV_GIO_API
#endif
#endif

// include files
#ifdef WIN 
#include <windows.h>
#endif
#include <stdlib.h>
#include <stdio.h>
#include <fstream.h>
#include <math.h>
#include <string.h>
#include <time.h>
#include "grid.h"
#include "area_class.h"
#include "macros.h"
#include "display.h"
#ifdef AV_GIO_API
#include "gioapi.h"
#endif

#define ELEV	0
#define REMOVE	1
#define SLOPE	2
#define AREA	3
#define QOVERT	4
#define FIELDS	5
#define FIELDS2	4	// for distance2outlet only
#define FLOW	2	// for distance2outlet only
#define DIST	3	// for distance2outlet only

#define NOREMSINK	'!'

#ifdef WIN 

#define DllExp extern "C" __declspec(dllexport)

// Removes Sinks
void calcRemoveSinks(Grid *grd, int rem_field, double soil_incr = RS_INCREMENT,
	int rem_max_pass = RS_MAXPASSES, int disp_mode = RS_MESSAGES); 

DllExp short int do_RemoveSinks(char *elv_grid, char *rem_grid = (char *)NULL,
	short int grid_mode = ARCINFO, float soil_incr = RS_INCREMENT, 
	short int rem_max_pass = RS_MAXPASSES, short int disp_mode = RS_MESSAGES);

DllExp short int do_CheckSinks(char *elv_grid, short int grid_mode = ARCINFO, 
	short int disp_mode = RS_MESSAGES);

// Removes Sinks for channels only
void calcRemoveSinks2(Grid *grd, int rem_field, double soil_incr = RS_INCREMENT,
	int rem_max_pass = RS_MAXPASSES, int disp_mode = RS_MESSAGES); 
DllExp short int do_RemoveSinks2(char *elv_grid, char *rem_grid = (char *)NULL,
	int in_grid_mode = ARCINFO, int out_grid_mode = ARCINFO,
	double soil_incr = RS_INCREMENT, int rem_max_pass = RS_MAXPASSES,
	int disp_mode = RS_MESSAGES);

// Calculates Slope 
void calcSlope(Grid *grd, int rem_field, int slp_field, 
	int slp_mode = ATAN_RAD, int disp_mode = GR_MESSAGES); 

DllExp short int do_Slope(char *rem_grid, char *slp_grid = (char *)NULL,
	short int grid_mode = ARCINFO, short int slp_mode = ATAN_RAD, 
	short int disp_mode = GR_MESSAGES);

// Calculates Curvature 
void calcCurvature(Grid *grd, int rem_field, int crv_field, 
	int disp_mode = GR_MESSAGES); 

DllExp short int do_Curvature(char *rem_grid, char *crv_grid = (char *)NULL,
	short int grid_mode = ARCINFO, short int disp_mode = GR_MESSAGES);

// Calculates Area
void calcArea(Grid *grd, int rem_field, int area_field,
	int area_mode = CA_MODE, int check_sinks = TRUE,
	int *sinks = (int *)NULL, int disp_mode = GR_MESSAGES);

DllExp short int do_Area(char *rem_grid, char *area_grid = (char *)NULL,
	short int grid_mode = ARCINFO, short int area_mode = CA_MODE, 
	short int check_sinks = TRUE, short int disp_mode = GR_MESSAGES);

 // Calculates q/T
void calcQoverT(Grid *grd, int slp_field, int area_field,
	int qt_field, int slope_mode = ATAN_RAD, double qt_ps = QT_PS, 
	double qt_phi = QT_PHI, int disp_mode = GR_MESSAGES); 

DllExp short int do_QoverT(char *slp_grid, char *area_grid, char *qt_grid = (char *)NULL,
    short int grid_mode = ARCINFO, short int slope_mode = ATAN_RAD, 
	float qt_ps = QT_PS, float qt_phi = QT_PHI, 
	short int disp_mode = GR_MESSAGES);

// Calculates q/T with cohesion and constant soil depth 
void calcQoverTCF(Grid *grd, int slp_field, int area_field,
	int qt_field, int slope_mode = ATAN_RAD, double qt_ps = QT_PS, 
	double qt_phi = QT_PHI, double qt_depth = QT_DEPTH, 
	double qt_coh = QT_COH, int disp_mode = GR_MESSAGES); 

DllExp short int do_QoverTCF(char *slp_grid, char *area_grid, char *qt_grid = (char *)NULL,
    short int grid_mode = ARCINFO, short int slope_mode = ATAN_RAD, 
	float qt_ps = QT_PS, float qt_phi = QT_PHI, 
	float qt_depth = QT_DEPTH, float qt_coh = QT_COH, 
	short int disp_mode = GR_MESSAGES);

// Calculates all
DllExp short int do_Shalstab(char *elv_grid, char *rem_grid, 
	char *slp_grid, char *area_grid, char *qt_grid = (char *)NULL,
	short int grid_mode = ARCINFO, float soil_incr = RS_INCREMENT, 
	float qt_ps = QT_PS, float qt_phi = QT_PHI, short int disp_mode = GR_MESSAGES);

// Calculates all with cohesion and constant soil depth
DllExp short int do_ShalstabCF(char *elv_grid, char *rem_grid, 
	char *slp_grid, char *area_grid, char *qt_grid = (char *)NULL,
	short int grid_mode = ARCINFO, float soil_incr = RS_INCREMENT, 
	float qt_ps = QT_PS, float qt_phi = QT_PHI, float qt_depth = QT_DEPTH, 
	float qt_coh = QT_COH, short int disp_mode = GR_MESSAGES);

// Random Grid Generator
DllExp short int do_Rangrid(char *in_grid, short int hits, short int range,
	char *out_grid = (char *)NULL, short int grid_mode = ARCINFO, 
	short int disp_mode = GR_MESSAGES);

// Adds two grids
void calcAddGrid(Grid *grd, int in_field1, int in_field2,
	int out_field, int disp_mode = GR_MESSAGES); 

DllExp short int do_GridAdd(char *in_grid1, char *in_grid2, char *out_grid = (char *)NULL,
    short int grid_mode = ARCINFO, short int disp_mode = GR_MESSAGES);

// Subtracts two grids
void calcSubGrid(Grid *grd, int in_field1, int in_field2,
	int out_field, int disp_mode = GR_MESSAGES); 

DllExp short int do_GridSub(char *in_grid1, char *in_grid2, char *out_grid = (char *)NULL,
    short int grid_mode = ARCINFO, short int disp_mode = GR_MESSAGES);

// Multiplies two grids
void calcMulGrid(Grid *grd, int in_field1, int in_field2,
	int out_field, int disp_mode = GR_MESSAGES); 

DllExp short int do_GridMul(char *in_grid1, char *in_grid2, char *out_grid = (char *)NULL,
    short int grid_mode = ARCINFO, short int disp_mode = GR_MESSAGES);

// Divides two grids
void calcDivGrid(Grid *grd, int in_field1, int in_field2,
	int out_field, int disp_mode = GR_MESSAGES); 

DllExp short int do_GridDiv(char *in_grid1, char *in_grid2, char *out_grid = (char *)NULL,
    short int grid_mode = ARCINFO, short int disp_mode = GR_MESSAGES);

// Tests read and write functions, converts formats
DllExp short int do_ReadWrite(char *in_grid, char *out_grid, short int in_mode = ARCINFO, 
	short int out_mode = ARCINFO, short int disp_mode = GR_MESSAGES);

// Converts from arcinfo to surfer
DllExp short int do_Arc2Surf(char *in_grid, char *out_grid, short int disp_mode = GR_MESSAGES);

// Converts from surfer to arcinfo
DllExp short int do_Surf2Arc(char *in_grid, char *out_grid, short int disp_mode = GR_MESSAGES);

// Calculates flow direction
void calcFlowDir(Grid *grd, int elev_field, int flow_field, int disp_mode);

// Calculates distance to outlet
void calcChDist2Out(Grid *grd, int flow_field, int dist_field, int disp_mode);

// Calculates all distance to outlet
int do_ChDist2Out(char *elv_grid, char *rem_grid, char *flow_grid,
	char *dist_grid, int in_grid_mode = ARCINFO, int out_grid_mode = 
	ARCINFO, double soil_incr = RS_INCREMENT, int rem_max_pass = 
	RS_MAXPASSES, int disp_mode = GR_MESSAGES);
#else

// Removes Sinks
void calcRemoveSinks(Grid *grd, int rem_field, double soil_incr = RS_INCREMENT,
	int rem_max_pass = RS_MAXPASSES, int disp_mode = RS_MESSAGES); 

short int do_RemoveSinks(char *elv_grid, char *rem_grid = (char *)NULL,
	short int grid_mode = ARCINFO, double soil_incr = RS_INCREMENT, 
	short int rem_max_pass = RS_MAXPASSES, short int disp_mode = RS_MESSAGES);

short int do_CheckSinks(char *elv_grid, short int grid_mode = ARCINFO,
	short int disp_mode = RS_MESSAGES);

// Removes Sinks for channels only
void calcRemoveSinks2(Grid *grd, int rem_field, double soil_incr = RS_INCREMENT,
	int rem_max_pass = RS_MAXPASSES, int disp_mode = RS_MESSAGES); 

short int do_RemoveSinks2(char *elv_grid, char *rem_grid = (char *)NULL,
	int in_grid_mode = ARCINFO, int out_grid_mode = ARCINFO,
	double soil_incr = RS_INCREMENT, int rem_max_pass = RS_MAXPASSES,
	int disp_mode = RS_MESSAGES);

// Calculates Slope 
void calcSlope(Grid *grd, int rem_field, int slp_field, 
	int slp_mode = ATAN_RAD, int disp_mode = GR_MESSAGES); 

short int do_Slope(char *rem_grid, char *slp_grid = (char *)NULL,
	short int grid_mode = ARCINFO, short int slp_mode = ATAN_RAD,
	short int disp_mode = GR_MESSAGES);

// Calculates Curvature 
void calcCurvature(Grid *grd, int rem_field, int crv_field, 
	int disp_mode = GR_MESSAGES); 

short int do_Curvature(char *rem_grid, char *crv_grid = (char *)NULL,
	short int grid_mode = ARCINFO, short int disp_mode = GR_MESSAGES);

// Calculates Area
void calcArea(Grid *grd, int rem_field, int area_field,
	int area_mode = CA_MODE, int check_sinks = TRUE,
	int *sinks = (int *)NULL, int disp_mode = GR_MESSAGES);

short int do_Area(char *rem_grid, char *area_grid = (char *)NULL,
	short int grid_mode = ARCINFO, short int area_mode = CA_MODE, 
	short int check_sinks = TRUE, short int disp_mode = GR_MESSAGES);

 // Calculates q/T
void calcQoverT(Grid *grd, int slp_field, int area_field,
	int qt_field, int slope_mode = ATAN_RAD, double qt_ps = QT_PS, 
	double qt_phi = QT_PHI, int disp_mode = GR_MESSAGES); 

short int do_QoverT(char *slp_grid, char *area_grid, char *qt_grid = (char *)NULL,
	short int grid_mode = ARCINFO, short int slope_mode = ATAN_RAD, 
	double qt_ps = QT_PS, double qt_phi = QT_PHI, 
	short int disp_mode = GR_MESSAGES);

// Calculates q/T with cohesion and constant soil depth 
void calcQoverTCF(Grid *grd, int slp_field, int area_field,
	int qt_field, int slope_mode = ATAN_RAD, double qt_ps = QT_PS, 
	double qt_phi = QT_PHI, double qt_depth = QT_DEPTH, 
	double qt_coh = QT_COH, int disp_mode = GR_MESSAGES); 

int do_QoverTCF(char *slp_grid, char *area_grid, char *qt_grid = (char *)NULL,
    int grid_mode = ARCINFO, int slope_mode = ATAN_RAD, 
	float qt_ps = QT_PS, float qt_phi = QT_PHI, 
	float qt_depth = QT_DEPTH, float qt_coh = QT_COH, 
	int disp_mode = GR_MESSAGES);

// Calculates all
short int do_Shalstab(char *elv_grid, char *rem_grid, char *slp_grid,
	char *area_grid, char *qt_grid = (char *)NULL,
	short int grid_mode = ARCINFO, double soil_incr = RS_INCREMENT, 
	double qt_ps = QT_PS, double qt_phi = QT_PHI, 
	short int disp_mode = GR_MESSAGES);

// Calculates all with cohesion and constant soil depth
short int do_ShalstabCF(char *elv_grid, char *rem_grid, 
	char *slp_grid, char *area_grid, char *qt_grid = (char *)NULL,
	short int grid_mode = ARCINFO, float soil_incr = RS_INCREMENT, 
	float qt_ps = QT_PS, float qt_phi = QT_PHI, float qt_depth = QT_DEPTH, 
	float qt_coh = QT_COH, int disp_mode = GR_MESSAGES);// Random Grid Generator

short int do_Rangrid(char *in_grid, short int hits, short int range,
	char *out_grid = (char *)NULL, short int grid_mode = ARCINFO, 
	short int disp_mode = GR_MESSAGES);

// Adds two grids
void calcAddGrid(Grid *grd, int in_field1, int in_field2,
	int out_field, int disp_mode = GR_MESSAGES); 

short int do_GridAdd(char *in_grid1, char *in_grid2, char *out_grid = (char *)NULL,
    short int grid_mode = ARCINFO, short int disp_mode = GR_MESSAGES);

void calcSubGrid(Grid *grd, int in_field1, int in_field2,
	int out_field, int disp_mode = GR_MESSAGES); 

short int do_GridSub(char *in_grid1, char *in_grid2, char *out_grid = (char *)NULL,
    short int grid_mode = ARCINFO, short int disp_mode = GR_MESSAGES);

void calcMulGrid(Grid *grd, int in_field1, int in_field2,
	int out_field, int disp_mode = GR_MESSAGES); 

short int do_GridMul(char *in_grid1, char *in_grid2, char *out_grid = (char *)NULL,
    short int grid_mode = ARCINFO, short int disp_mode = GR_MESSAGES);

void calcDivGrid(Grid *grd, int in_field1, int in_field2,
	int out_field, int disp_mode = GR_MESSAGES); 

short int do_GridDiv(char *in_grid1, char *in_grid2, char *out_grid = (char *)NULL,
    short int grid_mode = ARCINFO, short int disp_mode = GR_MESSAGES);

// Tests read and write functions, converts formats
short int do_ReadWrite(char *in_grid, char *out_grid, short int in_mode = ARCINFO, 
	short int out_mode = ARCINFO, short int disp_mode = GR_MESSAGES);

// Converts from arcinfo to surfer
short int do_Arc2Surf(char *in_grid, char *out_grid, short int disp_mode = GR_MESSAGES);

// Converts from surfer to arcinfo
short int do_Surf2Arc(char *in_grid, char *out_grid, short int disp_mode = GR_MESSAGES);

// Calculates flow direction
void calcFlowDir(Grid *grd, int elev_field, int flow_field, int disp_mode);

// Calculates distance to outlet
void calcChDist2Out(Grid *grd, int flow_field, int dist_field, int disp_mode);

// Calculates all distance to outlet
int do_ChDist2Out(char *elv_grid, char *rem_grid, char *flow_grid,
	char *dist_grid, int in_grid_mode = ARCINFO, int out_grid_mode = 
	ARCINFO, double soil_incr = RS_INCREMENT, int rem_max_pass = 
	RS_MAXPASSES, int disp_mode = GR_MESSAGES);


#endif
#endif