//  -*- Mode: C++;  -*-

//  File: macros.h

//  Author: Dino Bellugi (dino@geomorph.berkeley.edu)

//  Copyright  Dino Bellugi, BlueG SoftWear, U.C. Berkeley, 1999 (C)

// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// * FUNCTION: macros and constants definition

// *

// * RELATED PACKAGES: all

// *

// * HISTORY:

// * Created:  Mon Nov  6 1995 (dino)

// * Modified: Sat Jun 26 1999 (dino)

// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#ifndef	DEF_MACROS

#define	DEF_MACROS



// the following include file (notice.h) contains important copyright 

// information, as well as other legal statements. it must be present 

// in all files and in any distribution. removal or modification is

// strictly forbidden and violates u.s. and international copyright law.

#include "notice.h"

//



// constants

#define SQRT2		1.41421356237309504880

#define SQRT2_x2	2.82842412474619009760

#define VAL_PI		3.14159265358979323846

#define VAL_180_PI	57.2957795131

#define VAL_PI_180	0.01745329251994



// return values

#define OK				0

#define FALSE			0

#define TRUE			1

#define ERR_GENERIC		-1

#define ERR_NOTFOUND	-3

#define ERR_BADVALUE	-5

#define ERR_BADTYPE		-6

#define ERR_BADHEADER	-7

#define ERR_BADDIREC	-8

#define ERR_NOMEM		-10

#define ERR_MEMALLOC	-11

#define ERR_MEMFREE		-12

#define ERR_NOFILE		-20

#define ERR_FILECREATE	-21

#define ERR_FILEOPEN	-22

#define ERR_FILECLOSE	-23

#define ERR_ARCVIEW		-50

#define ERR_AV_CLCREATE	-51

#define ERR_AV_CLOPEN	-52

#define ERR_AV_AWSET	-53

#define MSG_SINKS		10

// macros

#define min(x,y) ((x)<(y)?(x):(y))

#define max(x,y) ((x)>(y)?(x):(y))

#define sqr(x)		((x) * (x))

#define cube(x)		((x) * (x) * (x))

#define mabs(n)		((n) < 0 ? -(n) : (n))

#define mfabs(x)	((x) < 0.0 ? -(x) : (x))

#define exp10(x)	(pow(10.0, (x)))

#define rnd(x)		((int)((x) + 0.5))

#define trn(x)		((int)(x))

#define lrnd(x)		((long)((x) + 0.5))

#define ltrn(x)		((long)(x))

#define urnd(x)         ((unsigned int)((x) + 0.5))

#define utrn(x)         ((unsigned int)(x))

#define ulrnd(x)	((unsigned long)((x) + 0.5))

#define ultrn(x)	((unsigned long)(x))

#define lclip(x, lb)	((x) < (lb) ? (lb) : (x))

#define uclip(x, ub)	((x) > (ub) ? (ub) : (x))

#define clip(x, lb, ub)	(lclip(uclip((x), (ub)), (lb)))

#define prcnt(x,y)	(((x) * 100.0) / (y))

#define odd(n)		((n) & 1)

#define even(n)         (!((n) & 1))

#define appName(args)	(strrchr(*args, '/') ? strrchr(*args, '/') + 1 : *args)

#define nextLine(fp)	{char c; while((c = fgetc(fp)) != '\n' && c != EOF);}

#define deg2rad(x)	((x) * VAL_PI_180)

#define rad2deg(x)	((x) * VAL_180_PI)



#endif

