//  -*- Mode: C++;  -*-

//  File: gridEdges.h

//  Author: Rob Reiss / Dino Bellugi (dino@geomorph.berkeley.edu)

//  Copyright (C) Rob Reiss, BlueG SoftWear, 1993-1999

// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// * FUNCTION: A set of doubles representing edge weights of a grid

// *

// * CLASSES: GridEdges

// * 

// * RELATED PACKAGES:

// *

// * HISTORY:

// * Created: Wed Jul 14 10:16:33 1993 (rob)

// * Modified: Tue Mar 30 00:26:15 1999 (dino)

// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#ifndef	DEF_GRIDEDGES

#define	DEF_GRIDEDGES



// the following include file (notice.h) contains important copyright 

// information, as well as other legal statements. it must be present 

// in all files and in any distribution. removal or modification is

// strictly forbidden and violates u.s. and international copyright law.

#include "notice.h"

//



#define GE_MESSAGES     1       // 0 = no messages, 1 = level 1 messages, etc.

#define GE_DEBUG        0       // 0 = no debug, 1 = level 1 debug, etc.


enum Direction {U=2,UR=1,R=0,DR=7,D=6,DL=5,L=4,UL=3,NODIR=-1};

//enum Direction {U=2,UR=1,R=0,DR=7,D=6,DL=5,L=4,UL=3};

inline double angleFactor(int k) { return k%2 ?  1.41421356237309504880 : 1.0;}



// Note: The directions above are represented by odd ints for diagonals

//       and even ints for laterals. DO NOT CHANGE THIS



// GridEdges is a data structure that holds a "weight" or float value for

// every connection that is made between adjacent grid cells in a grid.

// i.e. givin a grid we create a datastructure such that every cell

// in the grid has an edge with an associated weight that connects it

// to its eight neightboring cells.  Therefore each cell has an: up,down

// left,right,upleft,upright,downleft,downright edge. These edges are used

// to create a flow network for the grid. The "weight" of the edge represents

// the proportion of water comming into (positve) or leaving (negitive) a cell.



class GridEdges

{

private:

  int xdim,ydim;

  double* arr;

public:

  GridEdges(int xd,int yd);

  ~GridEdges();

  double get(int x,int y,Direction direc);         

  void set(int x,int y,Direction direc,double val);

};

#endif



