//  -*- Mode: C++;  -*-
//  File: remove_class.h
//  Author: Dino Bellugi - Rob Reiss (dino@geomorph.berkeley.edu)
//  Copyright (C) BlueG SoftWear 1997-1999
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// * FUNCTION: Is a grid holding the dem with no sinks
// *           
// * CLASSES:  RemoveSinks
// * 
// * RELATED PACKAGES: Grid
// *
// * HISTORY:
// * Created: Fri Nov 21 16:27:20 1997 (dino)
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#ifndef	DEF_REMOVESINKS
#define	DEF_REMOVESINKS

#include "grid.h"

#define RS_NEIGHBORS	1	// 0 = don't check, 1 = check neighbors
#define RS_MAXPASSES	100	// maximum number of passes
#define RS_MESSAGES	1	// message level
#define RS_CHECKSINKS	1	// 0 = don't check, 1 = test, 2 = check
#define RS_INCREMENT	0.1	// default soil increment

class RemoveSinks
{
private:
	int removeSinks(double increment = RS_INCREMENT,
		int neighbors = RS_NEIGHBORS, int field = 0);
	void checkSinkNeighbors(int i, int j,
		double increment = RS_INCREMENT, int field = 0);
	double sinkAddValue(int i, int j, int field = 0);
public:
	Grid *grdP;
	RemoveSinks(Grid *ingrd, double increment = RS_INCREMENT,
		int maxpasses = RS_MAXPASSES, int neighbors = RS_NEIGHBORS,
		int infield = 0, int outfield = 1);
        int checkForSinks(int disp = FALSE, int field = 0);
        int isSink(int i, int j, int field = 0);
};
#endif
