//  -*- Mode: C++;  -*-
//  File: 	ravel_class.h
//  Author: 	Dino Bellugi (dino@Moray.Berkeley.EDU)
//  Copyright 	(C) Dino Bellugi, 1996
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// * FUNCTION:	Produces a grid containing the volume of soil moved by
// *		ravelling into each cell that is an accumulation point.
// *		Each cell contributing to an accumulation point will 
// *		contain the value of the area contributing up to that
// *		cell (uphill from it), identified by a negative value.
// *		Ravel is distributed in 8 directions proportionally
// *		to slope, when slope is greater than a specified (input)
// *		threshold.
// *
// * CLASSES:	Ravel_Class
// * 
// * RELATED PACKAGES: Grid
// *
// * HISTORY:
// * Created: 	Wed Jul 21 12:27:20 1993 (rob)
//
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#ifndef	RAVEL_CLASS
#define	RAVEL_CLASS

#include "grid.h"

#define MESSAGES	1	// 0 = none, <n> = level<n>
#define AREA		0	// 0 = no area labelling, 1 = labelling
#define STREAMS		0	// 0 = no streams coverage, 1 = streams

class Ravel_Class : public Grid 
{
    
private:
	double critical_slope, ravel_constant;
	GridEdges* weights;
	Grid *z;
#if (STREAMS)
	Grid *c;

	int isUpStream(int i, int j, int k);
	int isDownStream(int i, int j, int k);
	int isDownStream2(int i, int j, int k);
#endif

	int checkForSinks(Grid &z); 
	void makeRavelWeights();  
	double getRavelArea(int i,int j);  
	void initRavel();           
	int isAccPoint(int i,int j);           

public:
#if (STREAMS)
	Ravel_Class(Grid &inz, Grid &inc, double critical_slope_in, 		
		double ravel_constant_in);
#else
	Ravel_Class(Grid &inz, double critical_slope_in, double ravel_constant_in);
#endif
	~Ravel_Class();
};

#endif


