//  -*- Mode: C++;  -*-
//  File: gridedges.h
//  Author: Dino Bellugi (dino@geomorph.berkeley.edu)
//  Copyright  Dino Bellugi, BlueG SoftWear, U.C. Berkeley, 1999 (C)
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// * FUNCTION: grid cells edge weights, used in 8-direction distribution
// *
// * RELATED PACKAGES: grid.cpp area_class.cpp
// *
// * HISTORY:
// * Created:  Wed Jul 14 1993 (dino, based on rob reiss' version)
// * Modified: Tue Mar 30 1999 (dino)
// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// the following include file (notice.h) contains important copyright 
// information, as well as other legal statements. it must be present 
// in all files and in any distribution. removal or modification is
// strictly forbidden and violates u.s. and international copyright law.
#include "notice.h"
//
#ifndef	DEF_GRIDEDGES
#define	DEF_GRIDEDGES

#define GE_MESSAGES     1       // 0 = no messages, 1 = level 1 messages, etc.
#define GE_DEBUG        0       // 0 = no debug, 1 = level 1 debug, etc.

enum Direction {U=2,UR=1,R=0,DR=7,D=6,DL=5,L=4,UL=3,NODIR=-1};

inline double angleFactor(int k) { return k%2 ?  1.41421356237309504880 : 1.0;}

// Note: The directions above are represented by odd ints for diagonals
//       and even ints for laterals. DO NOT CHANGE THIS

// GridEdges is a data structure that holds a "weight" or float value for
// every connection that is made between adjacent grid cells in a grid.
// i.e. givin a grid we create a datastructure such that every cell
// in the grid has an edge with an associated weight that connects it
// to its eight neightboring cells.  Therefore each cell has an: up,down
// left,right,upleft,upright,downleft,downright edge. These edges are used
// to create a flow network for the grid. The "weight" of the edge represents
// the proportion of water comming into (positve) or leaving (negitive) a cell.

class GridEdges
{
private:
  int xdim,ydim;
  double* arr;
public:
  GridEdges(int xd,int yd);
  ~GridEdges();
  double get(int x,int y,Direction direc);         
  void set(int x,int y,Direction direc,double val);
};
#endif

