#!/bin/csh -f
#

# Set the output file
set psfile = "./gmt.ps"

# Start the Postscript file 
# 
psbasemap -JM6.5i -R-101.295/-59.625/-14.592/16.661 -Ba10.000f10.000/a10.000f10.000NEWS:."":  -X0.75i -Y1.0i -P -K > $psfile 

# Add the Coastline and National Boundaries
# 
pscoast -K -O -J -R -B -N1 -N2 -W -Dl -A1303 -G250/250/200  >> $psfile 

# Add station locations.  
# Input are longitude latitude.
#
psxy -K -O -J -R -St0.25i -G0/0/0 <<EOF >> $psfile 
-78.451 0.238 
-79.837 9.167 
-70.634 8.884 
-90.286 -0.674 
-87.273 14.057 
-76.842 -11.988 
EOF

# End the Postscript File
# 
psxy -R -J -O /dev/null >> $psfile 

