function [u,v] = tk2uv(T,k)

% Hudson et al. (1989) eqn. (28)
tau = T*(1-abs(k));

if (tau*k < 0) % Second and fourth quadrants
    a = 0;
elseif (tau > 0 || k > 0) % First quadrant
    if (tau < 4*k); a = -0.5*tau; else a = -2*k; end
else % Third quadrant
    if (tau < 4*k); a = 2*k; else a = 0.5*tau; end
end

u = tau/(1 + a);
v = k/(1 + a);

