function stplot_sub(T,K)

figure; hold on; axis equal;

% X Grid
t = [-1 0 1]; lt = length(t);
k = -1:0.1:1; lk = length(k);
Ugx = ones(lt,1); Vgx = Ugx;
for j = 1:lk
   for i = 1:lt
        [Ugx(i),Vgx(i)] = tk2uv(t(i),k(j));
    end
line(Ugx, Vgx);
end
% Y Grid
t = [-1:0.1:1]; lt = length(t);
lk = 3;
Ugy = ones(lk,1); Vgy = Ugy;
for i = 1:lt
    k = [-1 t(i)/(4+abs(t(i))) 1];
    for j = 1:lk
        [Ugy(j),Vgy(j)] = tk2uv(t(i),k(j));
    end
line(Ugy, Vgy);
end

% Frame
xf = [4/3 0 -4/3 0]';
yf = [1/3 -1 -1/3 1]';
line(xf,yf,'Color','k');

% Axes
xa = [-1 1; 0 0];
ya = [0 0; -1 1];
line([-1 1],[0 0],'Color','r','linewidth',2);
line([0 0],[-1 1],'Color','r','linewidth',2);

[u v]=tk2uv(T,K);
plot(u,v,'ro');
axis equal
