%Program to plot many points on stplot from fwdmt.m

%%Plot Source Type Grid
figure; hold on; axis equal;

% X Grid
t = [-1 0 1]; lt = length(t);
k = -1:0.1:1; lk = length(k);
Ugx = ones(lt,1); Vgx = Ugx;
for j = 1:lk
   for i = 1:lt
        [Ugx(i),Vgx(i)] = tk2uv(t(i),k(j));
    end
line(Ugx, Vgx);
end
% Y Grid
t = [-1:0.1:1]; lt = length(t);
lk = 3;
Ugy = ones(lk,1); Vgy = Ugy;
for i = 1:lt
    k = [-1 t(i)/(4+abs(t(i))) 1];
    for j = 1:lk
        [Ugy(j),Vgy(j)] = tk2uv(t(i),k(j));
    end
line(Ugy, Vgy);
end

% Frame
xf = [4/3 0 -4/3 0]';
yf = [1/3 -1 -1/3 1]';
line(xf,yf,'Color','k');

% Axes
xa = [-1 1; 0 0];
ya = [0 0; -1 1];
line([-1 1],[0 0],'Color','r','linewidth',2);
line([0 0],[-1 1],'Color','r','linewidth',2);

temp=load('hudson.out');
%i=find(temp(:,5)>98.);
u=temp(:,3);
v=temp(:,4);
vr=temp(:,5);
plot(u,v,'r.');
axis equal
figure

[X,Y] = meshgrid(-1.4:0.1:1.4,-1:0.1:1);
x = reshape(X,[],1); y = reshape(Y,[],1);
tri = delaunay(x,y);
i=tsearch(x,y,tri,u,v);
ii=unique(i);
for j = 1:length(ii)
vrmax(j)=max(vr(find(i == ii(j))));
end
patch(x(tri(ii,:))',y(tri(ii,:))',vrmax'); caxis([0 100]);
axis equal
figure

clear vrmax
i=dsearch(x,y,tri,u,v);
%plot(ZZZ,ZZ)  %plot pdf
ii=unique(i);
for j = 1:length(ii)
vrmax(j)=max(vr(find(i == ii(j))));
end
scatter(x(ii),y(ii),5,vrmax,'+'); caxis([0 100]);
axis equal
figure

z=abs(x*0.);
for j=1:length(ii)
z(ii(j))=vrmax(j);
end
Z=reshape(z,21,29);
contour(X,Y,Z)
axis equal
