%*****************************************************************************************
%*                                                                                       *
%*   shadowing2.m                                                                        *
%*                                                                                       *
%*   function returns the P-wave polarity from azimuth and takeoff angle                 *
%*                                                                                       *
%*****************************************************************************************
function out=shadowing2(m,azi,theta)
% note theta is takeoff angle

%----------------------------------------------------------------------------------------
% lower hemisphere equal-area projection
%----------------------------------------------------------------------------------------


            sin_fi = sin(azi*pi/180);
            cos_fi = cos(azi*pi/180);
           
            n(2)  = sin(theta*pi/180)*sin_fi;   % n(2) is directed to the East
            n(1)  = sin(theta*pi/180)*cos_fi;   % n(1) is directed to the North
            n(3) = sqrt(1-n(1)^2-n(2)^2);

            u_radiation_z = 0;
            for i = 1:3
                for j = 1:3
                    u_radiation_z =  u_radiation_z + n(3)*n(i)*n(j)*m(i,j);
                end
            end
            
            sign_u_radiation_z = sign(u_radiation_z) 
            
