%program to compute scalar seismic moment, decompose a general moment tensor into 
%major/minor dc and dc+clvd

%Enter moment tensor here: Units 1E20 dyne cm
Mxx=10.8040;
Mxy=1.3970;
Mxz=0.8670;
Myy=0.7810;
Myz=-1.3690;
Mzz=-11.5850;

%Mxx=358.046;
%Mxy=348.525;
%Mxz=-136.625;
%Myy=445.952;
%Myz=-414.374;
%Mzz=574.682;

%Mxx=210.112
%Mxy=805.925
%Mxz=531.327
%Myy=2781.943
%Myz=-35.288
%Mzz=-2292.499

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%Do Not Edit Below%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

M=[Mxx Mxy Mxz; Mxy Myy Myz; Mxz Myz Mzz]
[b,c]=eig(M);
eigenvalues=[ c(1,1) c(2,2) c(3,3)];
deveigenval=eigenvalues-(c(3,3)+c(2,2)+c(1,1))/3;

 if(b(3,3) <= 0.)
   azimuth=atan2(b(2,3),b(1,3))*180/pi+180; %add 180 if vector is pointint up
 else
   azimuth=atan2(b(2,3),b(1,3))*180/pi;
 end
if(azimuth < 0.)
   azimuth += 360.;
end
if((b(1,3)*b(1,3)+b(2,3)*b(2,3)) == 0.)
 plunge=90.;
else
 plunge=atan(abs(b(3,3))/sqrt(b(1,3)*b(1,3)+b(2,3)*b(2,3)))*180/pi;
end
if(deveigenval(3) > deveigenval(2))
  fprintf('T-axis: Eigenvalue=%f  Azimuth=%.1f   Plunge=%.1f\n',deveigenval(3),azimuth,plunge)
elseif(deveigenval(3) < deveigenval(2))
  fprintf('P-axis: Eigenvalue=%f  Azimuth=%.1f   Plunge=%.1f\n',deveigenval(3),azimuth,plunge)
else
  fprintf('B-axis: Eigenvalue=%f  Azimuth=%.1f   Plunge=%.1f\n',deveigenval(3),azimuth,plunge)
end


 if(b(3,1) <= 0.)
   azimuth=atan2(b(2,1),b(1,1))*180/pi+180; %add 180 if vector is pointint up
 else
   azimuth=atan2(b(2,1),b(1,1))*180/pi;
 end
if(azimuth < 0.)
   azimuth += 360.;
end
if((b(1,1)*b(1,1)+b(2,1)*b(2,1)) == 0.)
  plunge=90.0;
else
plunge=atan(abs(b(3,1))/sqrt(b(1,1)*b(1,1)+b(2,1)*b(2,1)))*180/pi;
end
if(deveigenval(1) > deveigenval(2))
  fprintf('T-axis: Eigenvalue=%f  Azimuth=%.1f   Plunge=%.1f\n',deveigenval(1),azimuth,plunge)
elseif(deveigenval(1) < deveigenval(2))
  fprintf('P-axis: Eigenvalue=%f  Azimuth=%.1f   Plunge=%.1f\n',deveigenval(1),azimuth,plunge)
else
  fprintf('B-axis: Eigenvalue=%f  Azimuth=%.1f   Plunge=%.1f\n',deveigenval(1),azimuth,plunge)
end

 if(b(3,2) <= 0.)
   azimuth=atan2(b(2,2),b(1,2))*180/pi+180; %add 180 if vector is pointint up
 else
   azimuth=atan2(b(2,2),b(1,2))*180/pi;
 end
if(azimuth < 0.)
   azimuth += 360.;
end
if((b(1,2)*b(1,2)+b(2,2)*b(2,2)) == 0.)
 plunge=90.;
else
 plunge=atan(abs(b(3,2))/sqrt(b(1,2)*b(1,2)+b(2,2)*b(2,2)))*180/pi;
end
if(deveigenval(2) > deveigenval(2))
  fprintf('T-axis: Eigenvalue=%f  Azimuth=%.1f   Plunge=%.1f\n',deveigenval(2),azimuth,plunge)
elseif(deveigenval(2) < deveigenval(2))
  fprintf('P-axis: Eigenvalue=%f  Azimuth=%.1f   Plunge=%.1f\n',deveigenval(2),azimuth,plunge)
else
  fprintf('B-axis: Eigenvalue=%f  Azimuth=%.1f   Plunge=%.1f\n',deveigenval(2),azimuth,plunge)
end

%done


