function plotmt(m,pltnode)

%----------------------------------------------------------------------------------------
% calculation of a fault normal and slip from the moment tensor
%----------------------------------------------------------------------------------------
    angles_all(1,:) = angles(m);
    
    strike_1 = angles_all(1,1);
    dip_1    = angles_all(1,2);
    rake_1   = angles_all(1,3);

%----------------------------------------------------------------------------------------
% plotting the solution
%----------------------------------------------------------------------------------------
    figure; hold on; axis equal; axis off; 

    shadowing(m);

% boundary circle;
    Fi=0:0.1:361;
    plot(cos(Fi*pi/180.),sin(Fi*pi/180.),'k','LineWidth',1.5)
 
% denoting the North direction
    plot([0 0], [1 1.07],'k','LineWidth',1.5);

    text(-0.035, 1.15,'N','FontSize',14);
   if(pltnode==1)
      nodal_lines_(strike_1, dip_1, rake_1);
   end
    P_T_axes_(strike_1, dip_1, rake_1);

axis equal
