%program to compute scalar seismic moment, decompose a general moment tensor into 
%major/minor dc and dc+clvd

%Enter moment tensor here: Units 1E20 dyne cm
Mxx=2.30
Mxy=-0.07
Mxz=-0.18
Myy=2.32
Myz=0.13
Mzz=0.00

%Mxx=358.046
%Mxy=348.525
%Mxz=-136.625
%Myy=445.952
%Myz=-414.374
%Mzz=574.682

%Mxx=210.112
%Mxy=805.925
%Mxz=531.327
%Myy=2781.943
%Myz=-35.288
%Mzz=-2292.499

%Some test case moment tensors
%A=[1 6 0;6 -2 -1;0 -1 4];
%following is for strike=190,100 rake=-180,-10 dip=80,90
%A=[3.368 -9.254 -1.710; -9.254 -3.368 -0.302; -1.710 -0.302 0];
%following is for strike=190/284 rake=160/11 dip=80/70
%A=[3.130 -8.496 -2.165; -8.496 -4.300 2.882; -2.165 2.882 1.170]
%following is for strike=123/12 rake=45/149 dip=67/49
%A=[2.339 -4.971 5.624; -4.971 -7.455 0.358; 5.624 0.358 5.087]

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%Do Not Edit Below%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

A=[Mxx Mxy Mxz; Mxy Myy Myz; Mxz Myz Mzz]
plotmt(A,1)

[b,c]=eig(A);
eigenvalues=[ c(3,3) c(2,2) c(1,1)]


outfile=fopen("mtdecout","w+");


isomom=(trace(A)/3)*1e20;
isomag=(log10(isomom)-16.05)*2/3;
iso=(trace(A)/3)*eye(3,3);
AA=A - iso;


%Determine the eigenvalues and eigenvectors
[b,c]=eig(AA);
co=c;

%Order and save original eigenvalues to construct elemental tensors
%Construct Dyadic Description of Vector Dipoles
if(abs(co(1,1)) > abs(co(3,3)))
    m3=co(1,1);
    m2=co(3,3);
    m1=co(2,2);
%Construct dyadics
a3a3=horzcat(b(:,1),b(:,1),b(:,1));
a3a3=a3a3.*a3a3';
a2a2=horzcat(b(:,3),b(:,3),b(:,3));
a2a2=a2a2.*a2a2';
a1a1=horzcat(b(:,2),b(:,2),b(:,2));
a1a1=a1a1.*a1a1';
else
    m3=co(3,3);
    m2=co(1,1);
    m1=co(2,2);
%Construct dyadics
a3a3=horzcat(b(:,3),b(:,3),b(:,3));
a3a3=a3a3.*a3a3';
a2a2=horzcat(b(:,1),b(:,1),b(:,1));
a2a2=a2a2.*a2a2';
a1a1=horzcat(b(:,2),b(:,2),b(:,2));
a1a1=a1a1.*a1a1';
end

if(trace(A) > 0.0)
   fprintf('Explosion Moment=%.3E\n',isomom)
elseif(trace(A) < 0.0)
   fprintf('Implosion Moment=%.3E\n',isomom)
else
   fprintf('Isotropc Moment=%.3E\n',isomom)
end
m3
m2
m1


Mototal=0.5*(abs(m3)+abs(m2))*1.0E20;
fprintf('Dziewonski Moment=%.3E\n',Mototal)
Mototal=(abs(trace(A)/3)+abs(m3))*1.0E20;
fprintf('Major Deviatoric Eigenvalue=%.3E\n',abs(m3)*1e20)
fprintf('Bowers Moment=%.3E\n\n',Mototal)
totmag=(log10(Mototal)-16.05)*2/3
devmag=(log10(abs(m3)*1E20)-16.05)*2/3
%write  moment tensor
fprintf(outfile,"%f %f 0 %f %f %f %f %f %f %f 0 0 %s\n",
		1, 5, A(3,3), A(1,1), A(2,2),A(1,3), -A(2,3), -A(1,2),20*totmag/5.0,"OrigMT");
%write  moment tensor
fprintf(outfile,"%f %f 0 %f %f %f %f %f %f %f 0 0 %s\n",
		2, 5, AA(3,3), AA(1,1), AA(2,2),AA(1,3), -AA(2,3), -AA(1,2),20*devmag/5.0,"DevPart");

%Form the Major DC, perform eigenval/vector decomp and find focal
%parameters

major=m3*(a3a3-a2a2);%Form Major DC
plotmt(major,1)
[b,c]=eig(major); %Determine Eigenvectors and values
Mo=0.5*(abs(c(3,3))+abs(c(1,1)))*1.0E20;
nu1=(1/sqrt(2)).*(b(:,3)-b(:,1));%Compute fault normal T-P
 u1=(1/sqrt(2)).*(b(:,1)+b(:,3));%Compute slip direction
[strike1, rake1, dip1]=fpsol(nu1,u1);%Compute strike,rake,dip for plane-1
nu2=(1/sqrt(2)).*(b(:,1)+b(:,3));%Compute same for plane-2
 u2=(1/sqrt(2)).*(b(:,3)-b(:,1)); % T-P
[strike2, rake2, dip2]=fpsol(nu2,u2);
fprintf('Major Double Couple\n')
fprintf('Moment=%.3E\n',Mo)
fprintf('Strike    Rake      Dip\n')
fprintf('%4.0f      %4.0f     %4.0f\n',strike1,rake1,dip1) 
fprintf('%4.0f      %4.0f     %4.0f\n\n',strike2,rake2,dip2)

%Same for the Minor DC
minor=m1*(a1a1-a2a2);
plotmt(minor,1)

[b,c]=eig(minor);
Mo=0.5*(abs(c(3,3))+abs(c(1,1)))*1.0E20;
nu1=(1/sqrt(2)).*(b(:,3)-b(:,1));
 u1=(1/sqrt(2)).*(b(:,1)+b(:,3));
[strike1, rake1, dip1]=fpsol(nu1,u1);
nu2=(1/sqrt(2)).*(b(:,1)+b(:,3));
 u2=(1/sqrt(2)).*(b(:,3)-b(:,1));
[strike2, rake2, dip2]=fpsol(nu2,u2);
fprintf('Minor Double Couple\n')
fprintf('Moment=%.3E\n',Mo)
fprintf('Strike    Rake      Dip\n')
fprintf('%4.0f      %4.0f     %4.0f\n',strike1,rake1,dip1) 
fprintf('%4.0f      %4.0f     %4.0f\n\n',strike2,rake2,dip2)

dcmagmag=(log10(abs(m3)*1e20)-16.05)*2/3
dcminmag=(log10(abs(m1)*1e20)-16.05)*2/3
%rat=max([dcmagmag dcminmag isomag]);
rat=5.0;

%write  major minor dc decompositions
if(isomom != 0.)
fprintf(outfile,'%f %f 0 %f %f %f %f %f %f %f 0 0 %s\n',
1, 4, iso(3,3), iso(1,1), iso(2,2),iso(1,3), -iso(2,3), -iso(1,2),20*isomag/rat,"ISO");
end
fprintf(outfile,'%f %f 0 %f %f %f %f %f %f %f 0 0 %s\n',
2, 4, major(3,3), major(1,1), major(2,2),major(1,3), -major(2,3), -major(1,2),20*dcmagmag/rat,'MajorDC');
fprintf(outfile,'%f %f 0 %f %f %f %f %f %f %f 0 0 %s\n',
3, 4, minor(3,3), minor(1,1), minor(2,2),minor(1,3), -minor(2,3), -minor(1,2),20*dcminmag/rat,'MinorDC');

%DC - CLVD Decomposition
F=-1*m1/m3;
dc=m3*(1-2*F)*(a3a3-a2a2);
plotmt(dc,1)
clvd=m3*F*(2*a3a3-a2a2-a1a1);
plotmt(clvd,0)

dcmag=(log10(abs(m3*(1-2*F))*1e20)-16.05)*2/3;
clvdmag=(log10(abs(m3*F)*1e20)-16.05)*2/3;
rat=5.0;

[b,c]=eig(dc); %Determine Eigenvectors and values
Mo=0.5*(abs(c(3,3))+abs(c(1,1)))*1.0E20;
nu1=(1/sqrt(2)).*(b(:,3)-b(:,1));%Compute fault normal
 u1=(1/sqrt(2)).*(b(:,1)+b(:,3));%Compute slip direction
[strike1, rake1, dip1]=fpsol(nu1,u1);%Compute strike,rake,dip for plane-1
nu2=(1/sqrt(2)).*(b(:,1)+b(:,3));%Compute same for plane-2
 u2=(1/sqrt(2)).*(b(:,3)-b(:,1));
[strike2, rake2, dip2]=fpsol(nu2,u2);
fprintf('DC - CLVD Decomposition\n')
fprintf('Double Couple\n')
fprintf('Moment=%.3E\n',Mo)
fprintf('Strike    Rake      Dip\n')
fprintf('%4.0f      %4.0f     %4.0f\n',strike1,rake1,dip1) 
fprintf('%4.0f      %4.0f     %4.0f\n\n',strike2,rake2,dip2)

[b,c]=eig(clvd); %Determine Eigenvectors and values for CLVD
Mo=0.5*(abs(c(3,3))+abs(c(1,1)))*1.0E20;
fprintf('CLVD\n')
fprintf('Moment=%.3E\n',Mo)
fprintf('Azimuth and Plunge of Major CLVD Vector Dipole\n')
if(b(3,3) <= 0.)
   azimuth=atan(abs(b(1,3))/b(2,3))*180/pi+90.+180; %add 180 if vector is pointint up
else
   azimuth=atan(abs(b(1,3))/b(2,3))*180/pi+90.;
end
plunge=atan(abs(b(3,3)/sqrt(b(1,3)*b(1,3)+b(2,3)*b(2,3))))*180/pi;
fprintf('Azimuth=%.1f   Plunge=%.1f\n',azimuth,plunge)

%write  dc clvd decomposition
if(isomom != 0.)
fprintf(outfile,'%f %f 0 %f %f %f %f %f %f %f 0 0 %s\n',
1, 3, iso(3,3), iso(1,1), iso(2,2),iso(1,3), -iso(2,3), -iso(1,2),20*isomag/rat,'ISO');
end
fprintf(outfile,'%f %f 0 %f %f %f %f %f %f %f 0 0 %s\n',
2, 3, dc(3,3), dc(1,1), dc(2,2),dc(1,3), -dc(2,3), -dc(1,2),20*dcmag/rat,'DC');
fprintf(outfile,'%f %f 0 %f %f %f %f %f %f %f 0 0 %s\n',
3, 3, minor(3,3), clvd(1,1), clvd(2,2),clvd(1,3), -clvd(2,3), -clvd(1,2),20*clvdmag/rat,'CLVD');

% Source-type parameters
e = eig(A); % defined previously
miso = sum(e)/3;
mdev = e-miso;
[mdevs,is] = sort(abs(mdev));
mdev = mdev(is);
% T,k are source-type parameters
T = (2*mdev(1))/abs(mdev(3))
k = miso/(abs(miso)+abs(mdev(3)))
tau = T*(1-abs(k));
if (tau*k < 0) % Second and fourth quadrants
    a = 0;
elseif (tau > 0 || k > 0) % First quadrant
    if (tau < 4*k); a = -0.5*tau; else a = -2*k; end
else % Third quadrant
    if (tau < 4*k); a = 2*k; else a = 0.5*tau; end
end
% u,v are linear parameters of T,k (for plotting on x,y)
u = tau/(1 + a)
v = k/(1 + a)

stplot_sub(T,k)

fclose(outfile);
%done


