#ifndef __PG_Info_h
#define __PG_Info_h

#include <stdlib.h>
#include <stdio.h>
#include <string>
using namespace std;



class StaNetChanLoc {
private:
    string network;
    string station;
    string channel;
    string location;
public:
    StaNetChanLoc(string sta="", string net="", string chan="", string loc="");
    virtual ~StaNetChanLoc();

    string setStation(string sta);
    string setNetwork(string net);
    string setChannel(string chan);
    string setLocation(string loc);

    string getNetwork() const;
    string getStation() const;
    string getChannel() const;
    string getLocation() const;
    string getSNCL() const;


    virtual bool operator==(const StaNetChanLoc &A) const;
    virtual bool operator!=(const StaNetChanLoc &A) const;
};


class PG_Info
{
 private:
    double observation;
    float latitude;
    float longitude;
    string observation_time;
    //////////
    string observation_units;
    string latitude_units;
    string longitude_units;
    string observation_time_units;
    
 public:
    PG_Info(double obs = -9.9999, 
	    float lat = -999.9999, 
	    float lon = -999.9999,
	    string o_time = "2999-12-31T24:60:60.0000Z",
	    string obs_units = "cm/s",
	    string lat_units = "deg",
	    string lon_units = "deg",
	    string o_time_units = "UTC");
    virtual ~PG_Info();
    
    double setObservation(double obs);
    float setLatitude(float lat);
    float setLongitude(float lon);
    string setObservationTime(string o_time);

    string setObservationUnits(string obs_units);
    string setLatitudeUnits(string lat_units);
    string setLongitudeUnits(string lon_units);
    string setObservationTimeUnits(string o_time_units);

    double getObservation() const;
    float getLatitude() const;
    float getLongitude() const;
    string getObservationTime() const;

    string getObservationUnits() const;
    string getLatitudeUnits() const;
    string getLongitudeUnits() const;
    string getObservationTimeUnits() const;

    //    bool compareTimeSNCL(const PGVObservation &A) const;

    virtual bool operator==(const PG_Info &A) const;
    virtual bool operator!=(const PG_Info &A) const;
};

class PGAObservation: public PG_Info, public StaNetChanLoc
{
 public:
    PGAObservation(string sta="", 
		   string net="", 
		   string chan="", 
		   string loc="", 
		   double obs = -9.9999, 
		   float lat = -999.9999, 
		   float lon = -999.9999,
		   string o_time = "2999-12-31T24:60:60.0000Z",
		   string obs_units = "g",
		   string lat_units = "deg",
		   string lon_units = "deg",
		   string o_time_units = "UTC");
    virtual ~PGAObservation();

    //bool compareTimeSNCL(const PGAObservation &A) const;
    
    bool operator==(const PGAObservation &A) const;
    bool operator!=(const PGAObservation &A) const;
    
};


class PGVObservation:public PG_Info, public StaNetChanLoc
{
 public:
    PGVObservation(string sta="", 
		   string net="", 
		   string chan="", 
		   string loc="", 
		   double obs = -9.9999, 
		   float lat = -999.9999, 
		   float lon = -999.9999,
		   string o_time = "2999-12-31T24:60:60.0000Z",
		   string obs_units = "cm/s",
		   string lat_units = "deg",
		   string lon_units = "deg",
		   string o_time_units = "UTC");
    virtual ~PGVObservation();

    //bool compareTimeSNCL(const PGVObservation &A) const;
    bool operator==(const PGVObservation &A) const;
    bool operator!=(const PGVObservation &A) const;
    
};

class PGVPrediction: public StaNetChanLoc
{
 private:
    double prediction;
    double prediction_uncertainty;
    float applied_radius;
    string prediction_time;
    float prediction_time_uncertainty;
    float latitude;
    float longitude;

    string prediction_units;
    string prediction_uncertainty_units;
    string applied_radius_units;
    string prediction_time_units;
    string prediction_time_uncertainty_units;
    string latitude_units;
    string longitude_units;
 public:
    PGVPrediction(string sta="", 
		  string net="", 
		  string chan="", 
		  string loc="",
		  double pred = -9999.9999,
		  double pred_uncer = -99.9999,
		  string p_time = "2999-12-31T24:60:60.0000Z",
		  float p_time_uncer = -9.9999,
		  float app_rad = -99.9999,
		  float lat = -999.9999,
		  float lon = -999.9999,
		  string pred_units = "cm/s",
		  string pred_uncer_units = "cm/s",
		  string p_time_units = "UTC",
		  string p_time_uncer_units = "sec",
		  string app_rad_units = "km",
		  string lat_units = "deg",
		  string lon_units = "deg");
    virtual ~PGVPrediction();
    double setPrediction(double pred);
    double setPredictionUncertainty(double pred_uncer);
    string setPredictionTime(string o_time);
    float setPredictionTimeUncertainty(float o_time_uncer);
    float setAppliedRadius(float app_rad);
    float setLatitude(float lat);
    float setLongitude(float lon);

    string setPredictionUnits(string pred_units);
    string setPredictionUncertaintyUnits(string pred_uncer_units);
    string setPredictionTimeUnits(string o_time_units);
    string setPredictionTimeUncertaintyUnits(string o_time_uncer_units);
    string setAppliedRadiusUnits(string app_rad_units);
    string setLatitudeUnits(string lat_units);
    string setLongitudeUnits(string lon_units);

    double getPrediction() const;
    double getPredictionUncertainty() const;
    string getPredictionTime() const;
    float getPredictionTimeUncertainty() const;
    float getAppliedRadius() const;
    float getLatitude() const;
    float getLongitude() const;

    string getPredictionUnits() const;
    string getPredictionUncertaintyUnits() const;
    string getPredictionTimeUnits() const;
    string getPredictionTimeUncertaintyUnits() const;
    string getAppliedRadiusUnits() const;
    string getLatitudeUnits() const;
    string getLongitudeUnits() const;
    
    bool PGVPrediction::operator==(const PGVPrediction &A) const;
    bool PGVPrediction::operator!=(const PGVPrediction &A) const;
    
};




#endif
    
    
