#include "EventMessage.h"
#include <string.h>

EventMessage::EventMessage(int i,
			   float mag,
			   float mag_err,
			   float lat,
			   float lat_err,
			   float lon,
			   float lon_err,
			   float dep,
			   float dep_err,
			   string o_time,
			   float o_time_err,
			   float lklyhd) : CoreEventInfo(i, 
							 mag, 
							 mag_err, 
							 lat, 
							 lat_err, 
							 lon, 
							 lon_err, 
							 dep, 
							 dep_err, 
							 o_time, 
							 o_time_err, 
							 lklyhd),
					   ebool(false),
					   vbool(false),
					   obool(false),
					   emess(NULL),
					   vmess(NULL),
					   omess(NULL) { }

EventMessage::~EventMessage() 
{
    this->deleteElarmsMessage();
    this->deleteVSMessage();
    this->deleteOnSiteMessage();
}

void EventMessage::addElarmsMessage(char* ebuf,
			       int i,
			       float mag,
			       float mag_uncer,
			       float lat,
			       float lat_uncer,
			       float lon,
			       float lon_uncer,
			       float dep,
			       float dep_uncer,
			       string o_time,
			       float o_time_uncer,
			       float lklyhd)
{
    this->deleteElarmsMessage();
    ElarmsMessage* emess = new ElarmsMessage( i,
					      mag,
					      mag_uncer,
					      lat,
					      lat_uncer,
					      lon,
					      lon_uncer,
					      dep,
					      dep_uncer,
					      o_time,
					      o_time_uncer,
					      lklyhd );
    strcpy(elarmssysbuffer, ebuf);
	
}

void EventMessage::addVSMessage(char* vbuf,
			   int i,
			   float mag,
			   float mag_uncer,
			   float lat,
			   float lat_uncer,
			   float lon,
			   float lon_uncer,
			   float dep,
			   float dep_uncer,
			   string o_time,
			   float o_time_uncer,
			   float lklyhd)
{
    this->deleteVSMessage();
    VSMessage* vsmess = new VSMessage( i,
				       mag,
				       mag_uncer,
				       lat,
				       lat_uncer,
				       lon,
				       lon_uncer,
				       dep,
				       dep_uncer,
				       o_time,
				       o_time_uncer,
				       lklyhd );
    strcpy(vssysbuffer, vbuf);
}

void EventMessage::addOnSiteMessage(char* obuf,
			       int i,
			       float mag,
			       float mag_uncer,
			       float lat,
			       float lat_uncer,
			       float lon,
			       float lon_uncer,
			       float dep,
			       float dep_uncer,
			       string o_time,
			       float o_time_uncer,
			       float lklyhd)
{
    this->deleteOnSiteMessage();
    OnSiteMessage* omess = new OnSiteMessage( i,
					      mag,
					      mag_uncer,
					      lat,
					      lat_uncer,
					      lon,
					      lon_uncer,
					      dep,
					      dep_uncer,
					      o_time,
					      o_time_uncer,
					      lklyhd );
    strcpy(onsitesysbuffer, obuf);
}

int EventMessage::deleteElarmsMessage()
{
    if (ebool) {
	delete emess;
	elarmssysbuffer[0]='\0';
	return 1;
    }
    return 0;
}


int EventMessage::deleteVSMessage()
{
    if (vbool) {
	delete vmess;
	vssysbuffer[0]='\0';
	return 1;
    }
    return 0;
}

int EventMessage::deleteOnSiteMessage()
{
    if (obool) {
	delete omess;
	onsitesysbuffer[0]='\0';
	return 1;
    }
    return 0;
}    
