#ifndef __CoreEventInfo_h
#define __CoreEventInfo_h

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <list>
#include <string>
#include "PG_Info.h"
using namespace std;

enum eewSystemName {ELARMS, ONSITE, VS};

typedef list<StaNetChanLoc>::iterator SNCL_Iter;

class CoreEventInfo 
{
private:
    int id;
    int version;
    float magnitude;
    float magnitude_uncertainty;
    float latitude;
    float latitude_uncertainty;
    float longitude;
    float longitude_uncertainty;
    float depth;
    float depth_uncertainty;
    string origin_time;
    double origin_time_uncertainty;
    float likelyhood;
    bool sent_flag;

    string magnitude_units;
    string magnitude_uncertainty_units;
    string latitude_units;
    string latitude_uncertainty_units;
    string longitude_units;
    string longitude_uncertainty_units;
    string depth_units;
    string depth_uncertainty_units;
    string origin_time_units;
    string origin_time_uncertainty_units;

public:
    CoreEventInfo(int i=-9,
		  float mag=-9.9,
		  float mag_uncer=-9.9,
		  float lat=-999.9,
		  float lat_uncer=-999.9,
		  float lon=-999.9,
		  float lon_uncer=-999.9,
		  float dep=-9.9,
		  float dep_uncer=-9.9,
		  string o_time="2999-12-31T24:60:60.0000Z",
		  float o_time_uncer=-9.9,
		  float lklyhd=-9.9,
		  string mag_units = "Mw",
		  string mag_uncer_units = "Mw",
		  string lat_units = "deg",
		  string lat_uncer_units = "deg",
		  string lon_units = "deg",
		  string lon_uncer_units = "deg",
		  string dep_units = "km",
		  string dep_uncer_units = "km",
		  string o_time_units = "UTC",
		  string o_time_uncer_units = "sec"
		  );

    virtual ~CoreEventInfo();
    void updateVersion();
    void updateSent();

    //////////
    //setValue methods
    //////////
    int setID(int i);
    //int setVersion(int v);
    float setMagnitude(float mag);
    float setMagnitudeUncertainty(float mag_uncer);
    float setLatitude(float lat);
    float setLatitudeUncertainty(float lat_uncer);
    float setLongitude(float lon);
    float setLongitudeUncertainty(float lon_uncer);
    float setDepth(float dep);
    float setDepthUncertainty(float dep_uncer);
    string setOriginTime(string o_time);
    float setOriginTimeUncertainty(float o_time_uncer);
    float setLikelyhood(float lklyhd);


    //////////
    //setValueUnits methods
    //////////
    string setMagnitudeUnits(string mag_units);
    string setMagnitudeUncertaintyUnits(string mag_uncer_units);
    string setLatitudeUnits(string lat_units);
    string setLatitudeUncertaintyUnits(string lat_uncer_units);
    string setLongitudeUnits(string lon_units);
    string setLongitudeUncertaintyUnits(string lon_uncer_units);
    string setDepthUnits(string dep_units);
    string setDepthUncertaintyUnits(string dep_uncer_units);
    string setOriginTimeUnits(string o_time_units);
    string setOriginTimeUncertaintyUnits(string o_time_uncer_units);
    

    //////////
    //getValue methods
    //////////
    int getID() const;
    int getVersion() const;
    float getMagnitude() const;
    float getMagnitudeUncertainty() const;
    float getLatitude() const;
    float getLatitudeUncertainty() const;
    float getLongitude() const;
    float getLongitudeUncertainty() const;
    float getDepth() const;
    float getDepthUncertainty() const;
    string getOriginTime() const;
    float getOriginTimeUncertainty() const;
    float getLikelyhood() const;
    //string getTriggeredStations() const;
    //int getNumberTriggeredStations() const;
    

    //////////
    //getValueUnits methods
    //////////
    string getMagnitudeUnits() const;
    string getMagnitudeUncertaintyUnits() const;
    string getLatitudeUnits() const;
    string getLatitudeUncertaintyUnits() const;
    string getLongitudeUnits() const;
    string getLongitudeUncertaintyUnits() const;
    string getDepthUnits() const;
    string getDepthUncertaintyUnits() const;
    string getOriginTimeUnits() const;
    string getOriginTimeUncertaintyUnits() const;
    
    
};
#endif
