#ifndef __ElarmsMessage_h
#define __ElarmsMessage_h

#include "CoreEventInfo.h"

typedef list<PGVObservation>::iterator PGVObsIter;
typedef list<PGAObservation>::iterator PGAObsIter;

class ElarmsMessage : public CoreEventInfo
{
 private:
    list<PGVObservation> pgvelocity_observations;
    list<PGAObservation> pgacceleration_observations;
 public:
    ElarmsMessage(int i=-9,
		  float mag=-9.9,
		  float mag_uncer=-9.9,
		  float lat=-999.9,
		  float lat_uncer=-999.9,
		  float lon=-999.9,
		  float lon_uncer=-999.9,
		  float dep=-9.9,
		  float dep_uncer=-9.9,
		  string o_time="2999-12-31T24:60:60.0000Z",
		  float o_time_uncer=-9.9,
		  float lklyhd=-9.9);
    virtual ~ElarmsMessage();

    int getNumberVelocityObservations();
    int getNumberAccelerationObservations();
    

    list<PGVObservation>::iterator getPGVObservationsIteratorBegin();
    list<PGVObservation>::iterator getPGVObservationsIteratorEnd();
    list<PGAObservation>::iterator getPGAObservationsIteratorBegin();
    list<PGAObservation>::iterator getPGAObservationsIteratorEnd();

    int addPGVObservation(PGVObservation &A);
    int addPGVObservation(string sta,
			  string net, 
			  string chan, 
			  string loc, 
			  double obs, 
			  float lat, 
			  float lon,
			  string o_time,
			  string obs_units = "cm/s",
			  string lat_units = "deg",
			  string lon_units = "deg",
			  string o_time_units= "UTC");

    void deletePGVObservation(PGVObservation &A);
    void deletePGVObservation(string sta,
			      string net, 
			      string chan, 
			      string loc, 
			      double obs, 
			      float lat, 
			      float lon,
			      string o_time,
			      string obs_units = "cm/s",
			      string lat_units = "deg",
			      string lon_units = "deg",
			      string o_time_units= "UTC");
    void deletePGVObservation(string sta,
			      string net, 
			      string chan, 
			      string loc);
    
    int addPGAObservation(PGAObservation &A);
    int addPGAObservation(string sta,
			  string net, 
			  string chan, 
			  string loc, 
			  double obs, 
			  float lat, 
			  float lon,
			  string o_time,
			  string obs_units = "g",
			  string lat_units = "deg",
			  string lon_units = "deg",
			  string o_time_units= "UTC");


    void deletePGAObservation(PGAObservation &A);
    void deletePGAObservation(string sta,
			      string net, 
			      string chan, 
			      string loc, 
			      double obs, 
			      float lat, 
			      float lon,
			      string o_time,
			      string obs_units = "g",
			      string lat_units = "deg",
			      string lon_units = "deg",
			      string o_time_units= "UTC");
    void deletePGAObservation(string sta,
			      string net, 
			      string chan, 
			      string loc);

};


#endif
