#include "DMMessageSender.h"
#include <decaf/lang/Thread.h>
#include <iostream>
#include <fstream>

int main(int argc , char* argv[] ) {
    
    string texttosend;
    string fileflag = "-f";

    if ((argc > 2) && (fileflag.compare(*(argv+1)) == 0)) {
	ifstream file(*(argv + 2));
	if (file.is_open()) {
	    string line;
	    while (!file.eof()){
		getline(file, line);
		texttosend += line;
		texttosend += "\n";
		
	    }
	    file.close();
	} else {
	    std::cout << "can not open " << *(argv + 2) << endl;
	    return 1;
	}
    }
    else if (argc < 2) {
	std::cout << "amq_test_sender -f text_file" << endl;
	std::cout << "OR\namq_test_sender \"text to be sent\"" << endl;
	return 1;
    } else {
	texttosend = *(argv+1);
    }
    
    activemq::library::ActiveMQCPP::initializeLibrary();

    std::string brokerURI =
        "failover:(tcp://localhost:61616)";
    bool useTopics = true;
    bool sessionTransacted = false;
    std::string destinationName = "DecisionModule";
    enum eewSystemName eewsn = ONSITE;
    
    
    
    DMMessageSender senderE( brokerURI, destinationName, useTopics, sessionTransacted, ELARMS);
    DMMessageSender senderV( brokerURI, destinationName, useTopics, sessionTransacted, VS);
    DMMessageSender senderO( brokerURI, destinationName, useTopics, sessionTransacted, ONSITE);

    ElarmsMessage* em = new ElarmsMessage (234, 
				   3.5, 
				   1.454,
				   234.23,
				   0.345,
				   -234.7,
				   0.356,
				   9.1,
				   .789,
				   "3121-15-36U27:16:68.1111A",
				   23.45,
				   1.90);

    VSMessage* vsm = new VSMessage (234, 
				   3.5, 
				   1.454,
				   234.23,
				   0.345,
				   -234.7,
				   0.356,
				   9.1,
				   .789,
				   "3121-15-36U27:16:68.1111A",
				   23.45,
				   1.90);


    OnSiteMessage* vm = new OnSiteMessage (234, 
				   3.5, 
				   1.454,
				   234.23,
				   0.345,
				   -234.7,
				   0.356,
				   9.1,
				   .789,
				   "3121-15-36U27:16:68.1111A",
				   23.45,
				   1.90);


    vm->addPGVPrediction("On",
			 "Site",
			 "VPRED",
			 "01",
			 32158.549,
			 215.1581,
			 "time test",
			 1003,
			 10.5,
			 123.12,
			 32.312);


    vm->addPGVPrediction("On",
			 "Site",
			 "VPRED",
			 "02",
			 32158.549,
			 215.1581,
			 "time test",
			 12.3,
			 10.5,
			 123.12,
			 32.312);

    vm->addPGVPrediction("On",
			 "Site",
			 "VPRED",
			 "03",
			 32158.549,
			 215.1581,
			 "time test",
			 12.3,
			 10.5,
			 123.12,
			 32.312);
    vm->addPGVPrediction("On",
			 "Site",
			 "VPRED",
			 "04",
			 32158.549,
			 215.1581,
			 "time test",
			 12.3,
			 10.5,
			 123.12,
			 32.312);

    senderE.run();
    senderV.run();
    senderO.run();


    senderE.sendMessage(*em);
    senderV.sendMessage(*vsm);
    senderO.sendMessage(*vm);

    senderE.sendDeleteMessage(123456);    
    senderV.sendDeleteMessage(123456);
    senderO.sendDeleteMessage(123456);
    
        
    senderE.close();
    senderV.close();
    senderO.close();
    activemq::library::ActiveMQCPP::shutdownLibrary();
    return 0;
}
