#ifndef __DMMessageTestReceiver_h
#define __DMMessageTestReceiver_h

#include <activemq/library/ActiveMQCPP.h>
#include <decaf/lang/Runnable.h>
#include <decaf/util/concurrent/CountDownLatch.h>
#include <decaf/lang/Integer.h>
#include <decaf/lang/Long.h>
#include <decaf/lang/System.h>
#include <activemq/core/ActiveMQConnectionFactory.h>
#include <activemq/util/Config.h>
#include <cms/Connection.h>
#include <cms/Session.h>
#include <cms/TextMessage.h>
#include <cms/BytesMessage.h>
#include <cms/MapMessage.h>
#include <cms/ExceptionListener.h>
#include <cms/MessageListener.h>
#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <memory>
#include <string>

using namespace activemq;
using namespace activemq::core;
//using namespace activemq::transport;
using namespace decaf::lang;
using namespace decaf::util;
using namespace decaf::util::concurrent;
using namespace cms;
using namespace std;


class DMMessageTestReceiver : public ExceptionListener,
			  public MessageListener,
			  public Runnable 
{
private:
    Connection* connection;
    Session* session;
    Destination* destination;
    MessageConsumer* consumer;
    bool useTopic;
    bool sessionTransacted;
    std::string brokerURI;
    std::string destinationName;
    unsigned int messageCount;
    void cleanup();

public:
    DMMessageTestReceiver( const std::string& brokerURI = "failover:(tcp://169.229.197.23:61616)",
			const std::string& destinationName = "DecisionModuleElarms",
                        bool useTopic = true,
                        bool sessionTransacted = false);
    virtual ~DMMessageTestReceiver();
    void close();
    //void waitUntilReady();
    virtual void run();
    virtual void onMessage( const Message* message );
    virtual void onException( const CMSException& ex AMQCPP_UNUSED);
    virtual void transportInterrupted();
    virtual void transportResumed();
    
};

#endif
