#ifndef __OnSiteMessage_h
#define __OnSiteMessage_h

#include "CoreEventInfo.h"

typedef list<PGVPrediction>::iterator PGVPredIter;

class OnSiteMessage : public CoreEventInfo
{
 private:
    list<PGVPrediction> pgvelocity_predictions;
 public:
    OnSiteMessage(int i=-9,
		  float mag=-9.9,
		  float mag_uncer=-9.9,
		  float lat=-999.9,
		  float lat_uncer=-999.9,
		  float lon=-999.9,
		  float lon_uncer=-999.9,
		  float dep=-9.9,
		  float dep_uncer=-9.9,
		  string o_time="2999-12-31T24:60:60.0000Z",
		  float o_time_uncer=-9.9,
		  float lklyhd=-9.9);
    virtual ~OnSiteMessage();

    int getNumberVelocityPredictions();
    

    list<PGVPrediction>::iterator getPGVPredictionsIteratorBegin();
    list<PGVPrediction>::iterator getPGVPredictionsIteratorEnd();

    int addPGVPrediction(PGVPrediction &A);
    int addPGVPrediction(string sta,
			 string net, 
			 string chan, 
			 string loc, 
			 double pred,
			 double pred_uncer,
			 string p_time,
			 float p_time_uncer,
			 float app_rad,
			 float lat, 
			 float lon,
			 string pred_units = "cm/s",
			 string pred_uncer_units = "cm/s",
			 string p_time_units = "UTC",
			 string p_time_uncer_units = "sec",
			 string app_rad_units = "km",
			 string lat_units = "deg",
			 string lon_units = "deg");

    void deletePGVPrediction(PGVPrediction &A);
    void deletePGVPrediction(string sta,
			     string net, 
			     string chan, 
			     string loc, 
			     double pred,
			     double pred_uncer,
			     string p_time,
			     float p_time_uncer,
			     float app_rad,
			     float lat, 
			     float lon,
			     string pred_units = "cm/s",
			     string pred_uncer_units = "cm/s",
			     string p_time_units = "UTC",
			     string p_time_uncer_units = "sec",
			     string app_rad_units = "km",
			     string lat_units = "deg",
			     string lon_units = "deg");
    void deletePGVPrediction(string sta,
			     string net, 
			     string chan,
			     string loc);
    

};


#endif
