#include "ElarmsMessage.h"

ElarmsMessage::ElarmsMessage(int i,
			     float mag,
			     float mag_err,
			     float lat,
			     float lat_err,
			     float lon,
			     float lon_err,
			     float dep,
			     float dep_err,
			     string o_time,
			     float o_time_err,
			     float lklyhd) : CoreEventInfo(i, 
							   mag, 
							   mag_err, 
							   lat, 
							   lat_err, 
							   lon, 
							   lon_err, 
							   dep, 
							   dep_err, 
							   o_time, 
							   o_time_err, 
							   lklyhd) {}

ElarmsMessage::~ElarmsMessage() 
{}

list<PGVObservation>::iterator ElarmsMessage::getPGVObservationsIteratorBegin()  
{
    return pgvelocity_observations.begin();
}
list<PGVObservation>::iterator ElarmsMessage::getPGVObservationsIteratorEnd()  
{
    return pgvelocity_observations.end();
}
list<PGAObservation>::iterator ElarmsMessage::getPGAObservationsIteratorBegin()  
{
    return pgacceleration_observations.begin();
}
list<PGAObservation>::iterator ElarmsMessage::getPGAObservationsIteratorEnd() 
{
    return pgacceleration_observations.end();
}
int ElarmsMessage::getNumberVelocityObservations() 
{
    int result = 0;
    PGVObsIter i = pgvelocity_observations.begin();
    PGVObsIter e = pgvelocity_observations.end();
    for (i; i != e; i++) { result++; }
    return result;
}

int ElarmsMessage::getNumberAccelerationObservations() 
{
    int result = 0;
    PGAObsIter i = pgacceleration_observations.begin();
    PGAObsIter e = pgacceleration_observations.end();
    for (i; i != e; i++) { result++; }
    return result;
}
int ElarmsMessage::addPGVObservation( PGVObservation &A) 
{
    PGVObsIter i = pgvelocity_observations.begin();
    PGVObsIter e = pgvelocity_observations.end();
    for (i; i != e; i++) { 
	if (A == *i) {
	    return 0;
	}
    }
    pgvelocity_observations.push_back(A);
    this->updateVersion();
    return 1;
}
int ElarmsMessage::addPGVObservation(string sta,
				     string net, 
				     string chan, 
				     string loc, 
				     double obs, 
				     float lat, 
				     float lon,
				     string o_time,
				     string obs_units,
				     string lat_units,
				     string lon_units,
				     string o_time_units)
{
    PGVObservation A(sta, net, chan, loc, obs, lat, lon, o_time, obs_units, lat_units, lon_units, o_time_units);
    PGVObsIter i = pgvelocity_observations.begin();
    PGVObsIter e = pgvelocity_observations.end();
    for (i; i != e; i++) { 
	if (A == *i) {
	    return 0;
	}
    }
    pgvelocity_observations.push_back(A);
    this->updateVersion();
    return 1;
}
void ElarmsMessage::deletePGVObservation(PGVObservation &A) 
{
    pgvelocity_observations.remove(A);
    this->updateVersion();
}
void ElarmsMessage::deletePGVObservation(string sta,
					 string net, 
					 string chan, 
					 string loc, 
					 double obs, 
					 float lat, 
					 float lon,
					 string o_time,
					 string obs_units,
					 string lat_units,
					 string lon_units,
					 string o_time_units)
{
    PGVObservation A(sta, net, chan, loc, obs, lat, lon, o_time, obs_units, lat_units, lon_units, o_time_units);
    pgvelocity_observations.remove(A);
    this->updateVersion();
}

void ElarmsMessage::deletePGVObservation(string sta,
					 string net, 
					 string chan, 
					 string loc)
{
    StaNetChanLoc snclcomp(sta, net, chan, loc);
    PGVObsIter i = pgvelocity_observations.begin();
    PGVObsIter e = pgvelocity_observations.end();
    for (i; i != e; i++) { 
	if(i->getSNCL() == snclcomp.getSNCL()) {
	    pgvelocity_observations.erase(i);
	    this->updateVersion();
	}
    }
}
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
int ElarmsMessage::addPGAObservation( PGAObservation &A) 
{
    PGAObsIter i = pgacceleration_observations.begin();
    PGAObsIter e = pgacceleration_observations.end();
    for (i; i != e; i++) { 
	if (A == *i) {
	    return 0;
	}
    }
    pgacceleration_observations.push_back(A);
    this->updateVersion();
    return 1;
}
int ElarmsMessage::addPGAObservation(string sta,
				     string net,
				     string chan,
				     string loc,
				     double obs,
				     float lat,
				     float lon,
				     string o_time,
				     string obs_units,
				     string lat_units,
				     string lon_units,
				     string o_time_units)
{
    PGAObservation A(sta, net, chan, loc, obs, lat, lon, o_time);
    PGAObsIter i = pgacceleration_observations.begin();
    PGAObsIter e = pgacceleration_observations.end();
    for (i; i != e; i++) { 
	if (A == *i) {
	    return 0;
	}
    }
    pgacceleration_observations.push_back(A);
    this->updateVersion();
    return 1;
}
void ElarmsMessage::deletePGAObservation( PGAObservation &A) 
{
    pgacceleration_observations.remove(A);
    this->updateVersion();
}
void ElarmsMessage::deletePGAObservation(string sta,
					 string net, 
					 string chan, 
					 string loc, 
					 double obs, 
					 float lat, 
					 float lon,
					 string o_time,
					 string obs_units,
					 string lat_units,
					 string lon_units,
					 string o_time_units)
{
    PGAObservation A(sta, net, chan, loc, obs, lat, lon, o_time);
    pgacceleration_observations.remove(A);
    this->updateVersion();
}
void ElarmsMessage::deletePGAObservation(string sta,
					 string net, 
					 string chan, 
					 string loc)
{
    StaNetChanLoc snclcomp(sta, net, chan, loc);
    PGAObsIter i = pgacceleration_observations.begin();
    PGAObsIter e = pgacceleration_observations.end();
    for (i; i != e; i++) { 
	if(i->getSNCL() == snclcomp.getSNCL()) {
	    pgacceleration_observations.erase(i);
	    this->updateVersion();
	}
    }
}
