#include <stdio.h>
#include <iostream>
#include <sstream>
#include "DMMessageDecoder.h"

DMMessageDecoder::DMMessageDecoder(){
    coretemplate << "<core_info id=\" %d \">\n";
    coretemplate << "\t\t<mag units=\"Mw\"> %f </mag>\n";
    coretemplate << "\t\t<mag_err units=\"Mw\"> %f </mag_err>\n";
    coretemplate << "\t\t<lat units=\"deg\"> %f </lat>\n";
    coretemplate << "\t\t<lat_err units=\"deg\"> %f </lat_err>\n";
    coretemplate << "\t\t<lon units=\"deg\"> %f </lon>\n";
    coretemplate << "\t\t<lon_err units=\"deg\"> %f </lon_err>\n";
    coretemplate << "\t\t<depth units=\"km\"> %f </depth>\n";
    coretemplate << "\t\t<depth_err units=\"km\"> %f </depth_err>\n";
    //    coretemplate << "\t\t<orig_time units=\"UTC\"> %*s </orig_time>\n";
    coretemplate << "\t\t<orig_time %*s\n";
    coretemplate << "\t\t<orig_time_err units=\"sec\"> %f </orig_time_err>\n";
    coretemplate << "\t\t<likelyhood> %f </likelyhood>\n";
    coretemplate << "\t</core_info>\n";
    cout << coretemplate.str() << endl;
    //printf("%s", coretemplate.str());
}

DMMessageDecoder::~DMMessageDecoder(){
}

int DMMessageDecoder::decode(string messgstr) {
    //this decoder is temporary. will include an XML library.
    if(string::npos != messgstr.find("message_type=\"new\"")) {
	cout << "Received a NEW message" << endl;
	//cout << messgstr << endl;
	return decodeNew(messgstr);
    }
    else if (string::npos != messgstr.find("message_type=\"update\"")) {
	cout << "Received a UPDATE message" << endl;
	return decodeUpdate(messgstr);
    }
    else if (string::npos != messgstr.find("message_type=\"delete\"")) {
	cout << "Received a DELETE message" << endl;
	return decodeDelete(messgstr);
    } else {
	cout << "Cannot decode message" << endl;
	return 1;
    }
}

int DMMessageDecoder::decodeInfo(string messgstr, string binfostr, string einfostr, char* cbuff) 
{
    size_t length, l0, l1;
    l0 = messgstr.find(binfostr);
    l1 = messgstr.find(einfostr);
    length = l1 - l0 + einfostr.length();
    length = messgstr.copy(cbuff, length, l0);
    cbuff[length] = '\0';
    return 0;
}

EventMessage* DMMessageDecoder::createEventMessage(char* corebuf, string corelayout, char* sysbuff, enum eewSystemName sysName) 
{
    int id;
    float mag;
    float mag_uncer;
    float lat;
    float lat_uncer;
    float lon;
    float lon_uncer;
    float depth;
    float depth_uncer;
    float orig_time_uncer;
    float likelyhood;
    sscanf(corebuf, 
	   corelayout.c_str(), 
	   &id, 
	   &mag_uncer,
	   &lat,
	   &lat_uncer,
	   &lon,
	   &lon_uncer,
	   &depth,
	   &depth_uncer,
	   &orig_time_uncer,
	   &likelyhood);
    EventMessage* newEM = new EventMessage(id, mag, mag_uncer, lat, lat_uncer, lon, lon_uncer, depth, depth_uncer);
    if (sysName == ELARMS) {
	newEM->addElarmsMessage(sysbuff, id, mag, mag_uncer, lat, lat_uncer, lon, lon_uncer, depth, depth_uncer);
    }
    else if (sysName == VS) {
	newEM->addVSMessage(sysbuff, id, mag, mag_uncer, lat, lat_uncer, lon, lon_uncer, depth, depth_uncer);
    }
    else if (sysName == ONSITE) {
	newEM->addOnSiteMessage(sysbuff, id, mag, mag_uncer, lat, lat_uncer, lon, lon_uncer, depth, depth_uncer);
    }
    current_event_list.push_back(*newEM);
    return newEM;
    
}

EventMessage* DMMessageDecoder::updateEventMessage(char* corebuf, string corelayout, char* sysbuff, enum eewSystemName sysName) 
{
    int id;
    float mag;
    float mag_uncer;
    float lat;
    float lat_uncer;
    float lon;
    float lon_uncer;
    float depth;
    float depth_uncer;
    float orig_time_uncer;
    float likelyhood;
    sscanf(corebuf, 
	   corelayout.c_str(), 
	   &id, 
	   &mag_uncer,
	   &lat,
	   &lat_uncer,
	   &lon,
	   &lon_uncer,
	   &depth,
	   &depth_uncer,
	   &orig_time_uncer,
	   &likelyhood);
    EMIter i = current_event_list.begin();
    EMIter e = current_event_list.end();
    EventMessage* updateEM;
    
	    
    if (sysName == ELARMS) {
	for (i; i != e; i++) {
	    if (i->emess->getID() == id) {
		updateEM = &(*i);
	    }
	}
	updateEM->addElarmsMessage(sysbuff, id, mag, mag_uncer, lat, lat_uncer, lon, lon_uncer, depth, depth_uncer);
    }
    else if (sysName == VS) {
	for (i; i != e; i++) {
	    if (i->vmess->getID() == id) {	
		updateEM = &(*i);
	    }
	}
	updateEM->addVSMessage(sysbuff, id, mag, mag_uncer, lat, lat_uncer, lon, lon_uncer, depth, depth_uncer);
    }
    else if (sysName == ONSITE) {
	for (i; i != e; i++) {
	    if (i->omess->getID() == id) {
		updateEM = &(*i);
	    }
	}
	updateEM->addOnSiteMessage(sysbuff, id, mag, mag_uncer, lat, lat_uncer, lon, lon_uncer, depth, depth_uncer);
    }
    return updateEM;
}




int DMMessageDecoder::decodeNew(string messgstr) 
{
    char corebuffer[1024];
    char eewsysbuffer[8192];
    
    if (string::npos != messgstr.find("<event_message orig_sys=\"elarms\"")) {
	//cout << "Message from ELARMS" << endl;
	decodeInfo(messgstr, "<core_info", "</core_info>",  corebuffer);
	decodeInfo(messgstr, "<elarms_info>", "</elarms_info>",  eewsysbuffer);
	createEventMessage(corebuffer, coretemplate.str(), eewsysbuffer);
    }
    else if (string::npos != messgstr.find("<event_message orig_sys=\"vs\"")) {
	//cout << "Message from VS" << endl;
	decodeInfo(messgstr, "<core_info", "</core_info>",  corebuffer);
	decodeInfo(messgstr, "<vs_info>", "</vs_info>",  eewsysbuffer);
	createEventMessage(corebuffer, coretemplate.str(), eewsysbuffer);
    }
    else if (string::npos != messgstr.find("<event_message orig_sys=\"onsite\"")) {
	//cout << "Message from ONSITE" << endl;
	decodeInfo(messgstr, "<core_info", "</core_info>",  corebuffer);
	decodeInfo(messgstr, "<onsite_info>", "</onsite_info>",  eewsysbuffer);
	createEventMessage(corebuffer, coretemplate.str(), eewsysbuffer);
    } else {
	cout << "Couldn't decode message" << endl;
	return 1;
    }
    return 0;
}

int DMMessageDecoder::decodeUpdate(string messgstr) 
{
    char corebuffer[1024];
    char eewsysbuffer[8192];
    
    if (string::npos != messgstr.find("<event_message orig_sys=\"elarms\"")) {
	decodeInfo(messgstr, "<core_info", "</core_info>",  corebuffer);
	decodeInfo(messgstr, "<elarms_info>", "</elarms_info>", eewsysbuffer);
	updateEventMessage(
    }
    else if (string::npos != messgstr.find("<event_message orig_sys=\"vs\"")) {
	decodeInfo(messgstr, "<core_info", "</core_info>",  corebuffer);
	decodeInfo(messgstr, "<vs_info>", "</vs_info>",  eewsysbuffer);
    }
    else if (string::npos != messgstr.find("<event_message orig_sys=\"onsite\"")) {
	decodeInfo(messgstr, "<core_info", "</core_info>",  corebuffer);
	decodeInfo(messgstr, "<onsite_info>", "</onsite_info>",  eewsysbuffer);

    } else {
	cout << "Couldn't decode message" << endl;
	return 1;
    }
    return 0;
}

int DMMessageDecoder::decodeDelete(string messgstr) 
{
    char corebuffer[1024];

    if (string::npos != messgstr.find("<event_message orig_sys=\"elarms\"")) {
	decodeInfo(messgstr, "<core_info", "</core_info>",  corebuffer);
    }
    else if (string::npos != messgstr.find("<event_message orig_sys=\"vs\"")) {
	decodeInfo(messgstr, "<core_info", "</core_info>",  corebuffer);
    }
    else if (string::npos != messgstr.find("<event_message orig_sys=\"onsite\"")) {
	decodeInfo(messgstr, "<core_info", "</core_info>",  corebuffer);

    } else {
	cout << "Couldn't decode message" << endl;
	return 1;
    }
    //cout << "BUFFER: " << endl << corebuffer << endl;    
    return 0;
}
