/************************************************************************/
/*  Complex arithmetic functions.					*/
/************************************************************************/

#include    "complex.h"

DCOMPLEX dcmplx (real, imag)
    double	real, imag;
{   
    DCOMPLEX  result;	
    result.real = real;
    result.imag = imag;
    return(result); }

DCOMPLEX dcadd (cx, cy)
    DCOMPLEX cx, cy;
{
    DCOMPLEX  result;
    result.real = cx.real+cy.real;
    result.imag = cx.imag+cy.imag;
    return(result);
}

DCOMPLEX dcsub (cx, cy)
    DCOMPLEX cx, cy;
{
    DCOMPLEX  result;
    result.real = cx.real-cy.real;
    result.imag = cx.imag-cy.imag;
    return(result);
}

DCOMPLEX dcmult (cx, cy)
    DCOMPLEX cx, cy;
{
    DCOMPLEX  result;
    result.real = cx.real*cy.real - cx.imag*cy.imag;
    result.imag = cx.real*cy.imag + cx.imag*cy.real;
    return(result);
}

DCOMPLEX dcdiv (cx, cy)
    DCOMPLEX cx, cy;
{
    DCOMPLEX result;
    double  denominator = (cy.real*cy.real) + (cy.imag*cy.imag);
    result.real = (cx.real*cy.real + cx.imag*cy.imag) / denominator;
    result.imag = (cx.imag*cy.real - cx.real*cy.imag) / denominator;
    return(result);
}

